#ifndef DATALOG_H
#define DATALOG_H

#include <QElapsedTimer>
#include <QFile>
#include "safetypes.h"
#include "datalog_types.h"
#include "datalog_infoheader.h"
#include "datalog_packet.h"

#define MODE0MSG_MAX_ELEMENTS 128
#define MODE0MSG_MAX_MESSAGES 7
#define DEF_MAX_SHORTNAME_LENGTH 15
#define DEF_MAX_LONGNAME_LENGTH 28

class datalog_definition;
class datalog_packet;
class datalog_element;

class datalog {
public:
  datalog(QString name_in, QString path_in, datalog *tail_record);
  ~datalog();
  datalog_infoheader info;
  //----------------
  datalog_packet *add_mode1_packet(byte *raw_packet, datalog_definition *msg, int size);
  byte *add_speedpacket(byte *buf_in);
  void add_packet(datalog_packet *new_packet);
  //----------------
  safe_string filepath;
  safe_string name;
  //----------------
  void generate_testing_data();
  datalog_packet *latest_packet(int msg_no);
  datalog_packet *latest_packet();
  datalog_packet *oldest_packet(int msgnumber);
  datalog_packet *oldest_packet();
  unsigned int n_packets();
  unsigned int n_packets(datalog_element *e);
  timestamp_t oldest_timestamp();
  timestamp_t newest_timestamp();
  void restart_log();
  int get_pkt_count();
  //----------------
  datalog_packet *get_packet_by_timestamp(timestamp_t timestamp);
  datalog_packet *get_packet_by_sequence(unsigned int sequence);
  bool is_data();
  bool verify_datalog_timestamps();
  byte random_byte();
  void invalidate_log_timers();
  //----------------
  datalog *get_next();
  datalog *get_prev();
  datalog *get_first();
  datalog *get_last();
  datalog *get_by_name(QString search_name);
  datalog *get_by_index(int idx);
  void set_next(datalog *x);
  void set_prev(datalog *x);
  QMutex del_lock; // deletion lock
  bool does_message_data_exist(datalog_definition *msg);
private:
  QMutex m; // only locks structural next/prev
  datalog *next;
  datalog *prev;
  timestamp_t get_and_reset_timestamp();
  QElapsedTimer timestamp;
  datalog_packet *p; // pointer to latest packet
  datalog_packet *trash; // disposal facility
};

#endif // DATALOG_H
