#ifndef GRAPHING_H
#define GRAPHING_H

#include <QWidget>
#include <QPushButton>
#include "datalog.h"
#include "qcustomplot.h"

namespace Ui {
class graphing;
}

class graphing : public QWidget
{
  Q_OBJECT

public:
  explicit graphing(QWidget *parent, datalog_definition *def_in, datalog *log_in);
  ~graphing();

public slots:
  void new_display_log(datalog *log_in);
  void showEvent(QShowEvent *e);
  void move_cursor(double position);
private slots:
  void on_btn_select_topleft_clicked();
  void on_btn_select_topright_clicked();
  void on_btn_select_bottomleft_clicked();
  void on_btn_select_bottomright_clicked();
  void on_btn_select_topoverlay_clicked();
  void on_btn_select_bottomoverlay_clicked();
  void x2AxisChanged();
  void xAxisChanged();
  void on_setting_graph_dots_toggled(bool checked);
  void on_setting_graph_smooth_toggled(bool checked);
  void on_refresh_graph_btn_clicked();
  void on_graph_reset_zoom_btn_clicked();
  void graph_clicked_event(QMouseEvent *event);
private:
  Ui::graphing *ui;
  datalog_definition *def;
  datalog *log;
  datalog_element *select_element(datalog_element *current_element, bool display_bools);
  datalog_element *element_topleft;
  datalog_element *element_topright;
  datalog_element *element_bottomleft;
  datalog_element *element_bottomright;
  datalog_element *element_topoverlay;
  datalog_element *element_bottomoverlay;
  QCPItemLine *cursor_top;
  QCPItemLine *cursor_bottom;
  void configure_graphs();
  void config_graph_layout(QCustomPlot *graph);
  void set_plot_style(int style, QCustomPlot *graph);
  void set_line_style(int style, QCustomPlot *graph);
  void config_graph_axis(QCPAxis *axis, datalog_element *element_in);
  void config_graph_axis(QCPAxis *axis, QString label, int maxrange);
  void config_graph_axis(QCPAxis *axis); //blank
  void replot_upper_graph();
  void replot_lower_graph();
  void replot_all_graphs();
  void get_graphdata(int lr, QCustomPlot *graph, datalog_element *element, bool is_bool);
  void set_element_title(QPushButton *btn, datalog_element *e);
  void redraw_cursor();
  double cursor_position;
  void change_cursor_position(double pos);
signals:
  void request_log_position_change(double);
  void rangeChanged(QCPRange);
  void setRange(QCPRange);
};

#endif // GRAPHING_H
