#include "memory_ui.h"
#include "ui_memory_ui.h"

memory_ui::memory_ui(QWidget *parent, datastream_control *control_in) :
  QWidget(parent),
  ui(new Ui::memory_ui) {
  ui->setupUi(this);
  control = control_in;
  ui->getblmcells_btn->setEnabled(false);
}

memory_ui::~memory_ui() {
  delete ui;
}

void memory_ui::display_blm_cells(QByteArray data) {
  for(int cell=0;cell<=18;cell++) {
    ui->blm_cell_out_l->appendPlainText(QString::number((unsigned char)data.at(cell),10));
    ui->blm_cell_out_r->appendPlainText(QString::number((unsigned char)data.at(cell + 19),10));
  }
}

void memory_ui::connection_state_changed(int state_in) {
  if(state_in == STATE_CONNECTED) {
    ui->getblmcells_btn->setEnabled(true);
  } else {
    ui->getblmcells_btn->setEnabled(false);
  }
}

void memory_ui::on_getblmcells_btn_clicked() {
  ui->blm_cell_out_l->clear();
  ui->blm_cell_out_r->clear();
  control->blmcell_dump.request();
}
