#ifndef RAW_COMMAND_H
#define RAW_COMMAND_H

#include <QWidget>
#include "datastream.h"
#include "controller.h"

namespace Ui {
class raw_command;
}

class raw_command : public QWidget {
  Q_OBJECT

public:
  explicit raw_command(datastream_control *control_in, QWidget *parent = 0);
  ~raw_command();
  void on_interface_loaded();
public slots:
   void new_custom_log_entry(QString str);
   void recieve_connection_state(int c);
   void custom_a_copied();
   void custom_b_copied();
private:
  Ui::raw_command *ui;
  datastream_control *control;
  void set_interface_connstate(bool);
  void custom_1_reload();
  void custom_2_reload();
  void hex_to_str(QString q, byte *buf, int len);
private slots:
  //--------------------
  void on_custom_msg_1_textChanged(const QString);
  void on_custom_msg_2_textChanged(const QString);
  void on_custom_loop_1_toggled(bool checked);
  void on_custom_loop_2_toggled(bool checked);
  void on_custom_send_1_clicked();
  void on_custom_send_2_clicked();
  void on_custom_ecm_1_textChanged(const QString);
  void on_custom_ecm_2_textChanged(const QString);
  void on_clear_customlog_clicked();
  void on_custom_msg_1_returnPressed();
  void on_custom_msg_2_returnPressed();
  void on_custom_delay_textChanged(const QString &arg1);
  void on_custom_delay_2_textChanged(const QString &arg1);
  void on_idlemodscanbtn_clicked();
};

#endif // RAW_COMMAND_H
