#ifndef COMMON_H
#define COMMON_H

#include <QByteArray>

typedef unsigned char byte;

// global functions for working with 8 byte junk
unsigned int convert_twobytes(int index, byte *data);
float clamp(float in, float min, float max);
double clamp_d(double value, double min, double max);
unsigned int clamp(int in, int min, int max);
bool getbit(int index, int bpos, byte *data);
bool getbit(int bpos, byte data);
#define setbit(P,BPOS) P |= 1 << BPOS
#define clrbit(P,BPOS) P &= ~(1 << BPOS);
#define calc_msglength(LEN) (byte)(LEN + 0x52)
float celcius_to_farenheit(float degc);
float mph_to_kph(float mph);
bool strings_are_equal(const char *str_a, const char *str_b);

#endif // COMMON_H
