#include <QApplication>
#include <QMainWindow>
#include <QThread>
#include <chrono>
#include <thread>

#include "safetypes.h"
#include "datastream.h"
#include "datalog.h"
#include "config.h"
#include "common.h"

datastream_control::datastream_control() {
  m4_comm_init();
  connection_state.set(STATE_DISCONNECTED);
  enable_errors.enable();
  def = nullptr;
}

bool datastream_control::is_connected() {
  if(connection_state.get() == STATE_CONNECTED) {
    return true;
  } else {
    return false;
  }
}

bool datastream_control::is_disconnected() {
  if(connection_state.get() == STATE_DISCONNECTED) {
    return true;
  } else {
    return false;
  }
}

void datastream_control::reset() {
  cyldroptest.set(false);
  blmcell_dump.set(false);
  clear_dtc.set(false);;
  custom_a.send.set(false);
  custom_b.send.set(false);
}
