#include "autospark.h"
#include "ui_autospark.h"
#include "common.h"
#include <QCloseEvent>
#include <QDebug>

autospark::autospark(QWidget *parent) :
  QWidget(parent),
  ui(new Ui::autospark) {
  ui->setupUi(this);

  // init spk matrix
  for(int x=0;x<6;x++) {
    for(int y=0;y<5;y++) {
      spark_matrix[x][y] = 0;
    }
  }
}

autospark::~autospark() {
  delete ui;
}

//-----------------------------

int autospark::get_spk_mod(int rpm, int map) {
  int rpm_cell = select_cell(6000,6,rpm);
  int map_cell = select_cell(100,5,map);
  return spark_matrix[rpm_cell][map_cell];
}

void autospark::recv_new_sample(datalog_packet *pkt, datastream_control *control) {
  if(pkt->get_msgnumber() != 0x00) return;
  int aspkadvance = get_spk_mod(pkt->get_int("RPM"),pkt->get_float("MAP"));
  int m4spark = control->m4_get_spark();
  if(aspkadvance != m4spark) {
    emit(send_new_advance(aspkadvance));
  }
}

int autospark::select_cell(int range, int cells, float data) {
  float interval = range / cells;
  int cell = floor((data/(float)range)*(float(range)/interval));
  if(cell > cells - 1) return cells - 1;
  if(cell < 0) return 0;
  return cell;
}

void autospark::closeEvent(QCloseEvent *x) {
  x->accept();
}

void autospark::set_table_val(int rpm_axis, int map_axis, int val) {
  spark_matrix[rpm_axis - 1][map_axis - 1] = val;
}

//-----------------------------

void autospark::on_as_cell_1_1_valueChanged(int arg1)
{
  set_table_val(1,1,arg1);
}

void autospark::on_as_cell_1_2_valueChanged(int arg1)
{
   set_table_val(1,2,arg1);
}

void autospark::on_as_cell_1_3_valueChanged(int arg1)
{
    set_table_val(1,3,arg1);
}

void autospark::on_as_cell_1_4_valueChanged(int arg1)
{
    set_table_val(1,4,arg1);
}

void autospark::on_as_cell_1_5_valueChanged(int arg1)
{
    set_table_val(1,5,arg1);
}

void autospark::on_as_cell_2_1_valueChanged(int arg1)
{
    set_table_val(2,1,arg1);
}

void autospark::on_as_cell_2_2_valueChanged(int arg1)
{
   set_table_val(2,2,arg1);
}

void autospark::on_as_cell_2_3_valueChanged(int arg1)
{
    set_table_val(2,3,arg1);
}

void autospark::on_as_cell_2_4_valueChanged(int arg1)
{
    set_table_val(2,4,arg1);
}

void autospark::on_as_cell_2_5_valueChanged(int arg1)
{
    set_table_val(2,5,arg1);
}

void autospark::on_as_cell_3_1_valueChanged(int arg1)
{
    set_table_val(3,1,arg1);
}

void autospark::on_as_cell_3_2_valueChanged(int arg1)
{
    set_table_val(3,2,arg1);
}

void autospark::on_as_cell_3_3_valueChanged(int arg1)
{
    set_table_val(3,3,arg1);
}

void autospark::on_as_cell_3_4_valueChanged(int arg1)
{
    set_table_val(3,4,arg1);
}

void autospark::on_as_cell_3_5_valueChanged(int arg1)
{
    set_table_val(3,5,arg1);
}

void autospark::on_as_cell_4_1_valueChanged(int arg1)
{
    set_table_val(4,1,arg1);
}

void autospark::on_as_cell_4_2_valueChanged(int arg1)
{
    set_table_val(4,2,arg1);
}

void autospark::on_as_cell_4_3_valueChanged(int arg1)
{
    set_table_val(4,3,arg1);
}

void autospark::on_as_cell_4_4_valueChanged(int arg1)
{
    set_table_val(4,4,arg1);
}

void autospark::on_as_cell_4_5_valueChanged(int arg1)
{
    set_table_val(4,5,arg1);
}

void autospark::on_as_cell_5_1_valueChanged(int arg1)
{
    set_table_val(5,1,arg1);
}

void autospark::on_as_cell_5_2_valueChanged(int arg1)
{
    set_table_val(5,2,arg1);
}

void autospark::on_as_cell_5_3_valueChanged(int arg1)
{
    set_table_val(5,3,arg1);
}

void autospark::on_as_cell_5_4_valueChanged(int arg1)
{
    set_table_val(5,4,arg1);
}

void autospark::on_as_cell_5_5_valueChanged(int arg1)
{
    set_table_val(5,5,arg1);
}

void autospark::on_as_cell_6_1_valueChanged(int arg1)
{
    set_table_val(6,1,arg1);
}

void autospark::on_as_cell_6_2_valueChanged(int arg1)
{
    set_table_val(6,2,arg1);
}

void autospark::on_as_cell_6_3_valueChanged(int arg1)
{
    set_table_val(6,3,arg1);
}

void autospark::on_as_cell_6_4_valueChanged(int arg1)
{
    set_table_val(6,4,arg1);
}

void autospark::on_as_cell_6_5_valueChanged(int arg1)
{
    set_table_val(6,5,arg1);
}
