#ifndef AUTOSPARK_H
#define AUTOSPARK_H

#include <QDialog>
#include "datalog.h"
#include "datastream.h"
#include <QSpinBox>

namespace Ui {
class autospark;
}

class autospark : public QWidget
{
  Q_OBJECT

public:
  explicit autospark(QWidget *parent = 0);
  ~autospark();
  int get_spk_mod(int rpm, int map);

public slots:
  void recv_new_sample(datalog_packet *pkt, datastream_control *control);

signals:
  void send_new_advance(int);

private slots:
  void on_as_cell_1_1_valueChanged(int arg1);
  void on_as_cell_1_2_valueChanged(int arg1);
  void on_as_cell_1_3_valueChanged(int arg1);
  void on_as_cell_1_4_valueChanged(int arg1);
  void on_as_cell_1_5_valueChanged(int arg1);
  void on_as_cell_2_1_valueChanged(int arg1);
  void on_as_cell_2_2_valueChanged(int arg1);
  void on_as_cell_2_3_valueChanged(int arg1);
  void on_as_cell_2_4_valueChanged(int arg1);
  void on_as_cell_2_5_valueChanged(int arg1);
  void on_as_cell_3_1_valueChanged(int arg1);
  void on_as_cell_3_2_valueChanged(int arg1);
  void on_as_cell_3_3_valueChanged(int arg1);
  void on_as_cell_3_4_valueChanged(int arg1);
  void on_as_cell_3_5_valueChanged(int arg1);
  void on_as_cell_4_1_valueChanged(int arg1);
  void on_as_cell_4_2_valueChanged(int arg1);
  void on_as_cell_4_3_valueChanged(int arg1);
  void on_as_cell_4_4_valueChanged(int arg1);
  void on_as_cell_4_5_valueChanged(int arg1);
  void on_as_cell_5_1_valueChanged(int arg1);
  void on_as_cell_5_2_valueChanged(int arg1);
  void on_as_cell_5_3_valueChanged(int arg1);
  void on_as_cell_5_4_valueChanged(int arg1);
  void on_as_cell_5_5_valueChanged(int arg1);
  void on_as_cell_6_1_valueChanged(int arg1);
  void on_as_cell_6_2_valueChanged(int arg1);
  void on_as_cell_6_3_valueChanged(int arg1);
  void on_as_cell_6_4_valueChanged(int arg1);
  void on_as_cell_6_5_valueChanged(int arg1);

private:
  Ui::autospark *ui;
  void closeEvent(QCloseEvent *x);
  void set_table_val(int rpm_axis, int map_axis, int val);
  int spark_matrix[6][6];
  int select_cell(int range, int cells, float data);
};

#endif // AUTOSPARK_H
