#include "common.h"

bool getbit(int index, int bpos, byte *data) {
  byte i = data[index];
  return (bool)0^(i>>bpos&0x01);
}

bool getbit(int index, int bpos, QByteArray data) {
  byte i = data[index];
  return (bool)0^(i>>bpos&0x01);
}

bool getbit(int bpos, byte data) {
  return (bool)0^(data>>bpos&0x01);
}

unsigned int convert_twobytes(int index, byte *data) {
  byte *i = &(data[index]);
  return (unsigned int)((*i<<8)|*(i+1));
}

unsigned int convert_twobytes(int index, QByteArray data_in) {
  byte data[2];
  data[0] = data_in.at(index);
  data[1] = data_in.at(index + 1);
  byte *i = &(data[0]);
  return (unsigned int)((*i<<8)|*(i+1));
}

float clamp(float in, float min, float max) {
  if(in < min) return min;
  if(in > max) return max;
  return in;
}

unsigned int clamp(int in, int min, int max) {
  if(in < min) return min;
  if(in > max) return max;
  return in;
}

double clamp_d(double value, double min, double max) {
  if(value > max) return max;
  if(value < min) return min;
  return value;
}

float celcius_to_farenheit(float degc) {
  return (((degc * 9) / 5) + 32);
}

float mph_to_kph(float mph) {
  return mph * 1.609344;
}

bool strings_are_equal(const char *str_a, const char *str_b) {
  int x = 0;
  int y = 0;
  while(str_a[x] == str_b[x]) {
    x++;
    y++;
    if(str_a[x] == 0 && str_b[x] == 0) return true;
  }
  return false;
}
