#ifndef CONTROLLER_H
#define CONTROLLER_H

#include <QDialog>
#include "datalog.h"
#include "datastream.h"
#include "notepad.h"
#include "autospark.h"

namespace Ui {
class controller;
}

class controller : public QWidget {
  Q_OBJECT

public:
  explicit controller(datastream_control *control_in, datalog *log_in, QWidget *parent);
  ~controller();
  void on_interface_loaded();
public slots:
  void autospark_new_advance(int advance);
  void recieve_new_packet(datalog_packet *p);
signals:
  void send_autospark_parameters(datalog_packet *, datastream_control *);
  void send_new_note(QString);
private:
  Ui::controller *ui;
  datastream_control *control;
  datalog *log;
  void update_idle_mode4();
  int commanded_idle;
  void append_memo(QString str);
  autospark *aspk_ui; // autospark ui
  void update_m4_raw_display();
  void reset_controls_default();
  void enable_clblm_controls(bool value);
private slots:
  void on_fan1_swauto_toggled(bool checked);
  void on_fan1_swon_toggled(bool checked);
  void on_fan1_swoff_toggled(bool checked);
  void on_fan2_swauto_toggled(bool checked);
  void on_fan2_swon_toggled(bool checked);
  void on_fan2_swoff_toggled(bool checked);
  void on_loop_swauto_toggled(bool checked);
  void on_loop_swopen_toggled(bool checked);
  void on_loop_swclosed_toggled(bool checked);
  void on_blm_swauto_toggled(bool checked);
  void on_blm_swon_toggled(bool checked);
  void on_blm_swoff_toggled(bool checked);
  void on_ccp_swoff_toggled(bool checked);
  void on_ac_swauto_toggled(bool checked);
  void on_ac_swon_toggled(bool checked);
  void on_ac_swoff_toggled(bool checked);
  void on_air_swauto_toggled(bool checked);
  void on_air_swon_toggled(bool checked);
  void on_air_swoff_toggled(bool checked);
  void on_ccp_swauto_toggled(bool checked);
  void on_ccp_swon_toggled(bool checked);
  void on_slider_idle_sliderMoved(int position);
  void on_check_usesteps_toggled(bool checked);
  void on_idle_override_toggled(bool checked);
  void on_slider_sparkmod_valueChanged(int value);
  void on_modify_spark_box_toggled(bool checked);
  void on_slider_afr_valueChanged(int value);
  void on_check_forceafr_toggled(bool checked);
  void on_autospark_box_toggled(bool checked);
  void on_clear_blm_btn_clicked();
  void on_btn_autospark_edit_clicked();
  void on_btn_snapshop_afr_clicked();
  void on_btn_snapshop_idle_clicked();
  void on_btn_snapshop_spark_clicked();
  void on_setting_limit_timing_toggled(bool checked);
  void on_shift_auto_toggled(bool checked);
  void on_shift_1_toggled(bool checked);
  void on_shift_2_toggled(bool checked);
  void on_shift_3_toggled(bool checked);
  void on_shift_4_toggled(bool checked);
  void on_tcc_auto_toggled(bool checked);
  void on_tcc_off_toggled(bool checked);
  void on_tcc_on_toggled(bool checked);
  void on_cylcut_0_toggled(bool checked);
  void on_cylcut_1_toggled(bool checked);
  void on_cylcut_2_toggled(bool checked);
  void on_cylcut_3_toggled(bool checked);
  void on_cylcut_4_toggled(bool checked);
  void on_cylcut_5_toggled(bool checked);
  void on_cylcut_6_toggled(bool checked);
  void on_cylcut_7_toggled(bool checked);
  void on_cylcut_8_toggled(bool checked);
  void drop_cyl(int cylid);
  void closeEvent(QCloseEvent *x);
  void on_cel_btn_toggled(bool checked);
  void on_check_linepressure_toggled(bool checked);
  void on_slider_linepressure_valueChanged(int value);
  void on_check_egr_toggled(bool checked);
  void on_slider_egr_valueChanged(int value);
  void on_btn_dangerous_toggled(bool checked);
};


#endif // CONTROLLER_H
