#include "raw_command.h"
#include "ui_raw_command.h"
#include "common.h"

raw_command::raw_command(datastream_control *control_in, QWidget *parent) :
  QWidget(parent),
  ui(new Ui::raw_command) {
  ui->setupUi(this);
  control = control_in;
}

raw_command::~raw_command() {
  delete ui;
}

void raw_command::on_interface_loaded() {
  control->custom_a.postdelay.set(20);
  control->custom_b.postdelay.set(20);
  ui->custom_msg_1->clear();
  custom_1_reload();
  ui->custom_msg_2->clear();
  custom_2_reload();
}

void raw_command::recieve_connection_state(int c) {
  switch(c) {
  case STATE_CONNECTED:
    set_interface_connstate(true);
    break;
  case STATE_CONNECTING:
    set_interface_connstate(false);
    break;
  case STATE_DISCONNECTING:
    set_interface_connstate(false);
    break;
  case STATE_DISCONNECTED:
    set_interface_connstate(false);
    break;
  }
}

void raw_command::set_interface_connstate(bool) {

}

void raw_command::on_custom_msg_1_textChanged(const QString) {
  custom_1_reload();
}

void raw_command::on_custom_msg_2_textChanged(const QString) {
  custom_2_reload();
}

void raw_command::on_custom_ecm_1_textChanged(const QString) {
  custom_1_reload();
}

void raw_command::on_custom_ecm_2_textChanged(const QString){
  custom_2_reload();
}

void raw_command::on_custom_msg_1_returnPressed() {
  // FIXME
//  if(connection_state != STATE_CONNECTED) return;
//  sched_custom_a = true;
//  ui->custom_msg_1->setEnabled(false);
//  ui->custom_ecm_1->setEnabled(false);
}

void raw_command::on_custom_msg_2_returnPressed() {
    // FIXME
//  if(connection_state != STATE_CONNECTED) return;
//  sched_custom_b = true;
//  ui->custom_msg_2->setEnabled(false);
 // ui->custom_ecm_2->setEnabled(false);
}

void raw_command::on_custom_loop_1_toggled(bool checked) {
  control->custom_a.loop.set(checked);
  if(checked == true) control->custom_a.send.request();
  ui->custom_msg_1->setDisabled(checked);
  ui->custom_ecm_1->setDisabled(checked);
  ui->custom_send_1->setDisabled(checked);
}

void raw_command::on_custom_loop_2_toggled(bool checked) {
  control->custom_b.loop.set(checked);
  if(checked == true) control->custom_b.send.request();
  ui->custom_msg_2->setDisabled(checked);
  ui->custom_ecm_2->setDisabled(checked);
  ui->custom_send_2->setDisabled(checked);
}

void raw_command::on_custom_send_1_clicked() {
  ui->custom_ecm_1->setEnabled(false);
  ui->custom_msg_1->setEnabled(false);
  ui->custom_send_1->setEnabled(false);
  control->custom_a.send.request();
}

void raw_command::on_custom_send_2_clicked() {
  ui->custom_ecm_2->setEnabled(false);
  ui->custom_msg_2->setEnabled(false);
  ui->custom_send_2->setEnabled(false);
  control->custom_b.send.request();
}

void raw_command::custom_a_copied() {
  if(ui->custom_loop_1->isChecked() == true) return;
  ui->custom_ecm_1->setEnabled(true);
  ui->custom_msg_1->setEnabled(true);
  ui->custom_send_1->setEnabled(true);
}

void raw_command::custom_b_copied() {
  if(ui->custom_loop_2->isChecked() == true) return;
  ui->custom_ecm_2->setEnabled(true);
  ui->custom_msg_2->setEnabled(true);
  ui->custom_send_2->setEnabled(true);
}

void raw_command::on_clear_customlog_clicked() {
   ui->custom_out->clear();
}

void raw_command::on_custom_delay_textChanged(const QString &arg1) {
  control->custom_a.postdelay.set(arg1.toInt());
}

void raw_command::on_custom_delay_2_textChanged(const QString &arg1) {
    control->custom_b.postdelay.set(arg1.toInt());
}

void raw_command::new_custom_log_entry(QString str) {
  ui->custom_out->append(str);
  QTextCursor c = ui->custom_out->textCursor();
  c.movePosition(QTextCursor::End);
  ui->custom_out->setTextCursor(c);
}

void raw_command::hex_to_str(QString q, byte *buf, int len) {
  int h_idx = 0;
  for(int x=0;x<len;x++) {
    bool ok;
    QStringRef hex_chars(&q, h_idx, 2);
    h_idx += 2;
    buf[x] = hex_chars.toUInt(&ok,16);
    if(ok == false) {
      buf[x] = 0x00;
    }
  }
}

void raw_command::custom_1_reload() {
  byte custom_buf_a[MAX_WRITE_BUF];
  QString main_text = ui->custom_msg_1->text();
  int length = main_text.length()/2;
  hex_to_str(main_text,custom_buf_a + 2,length);
  QString ecm_text = ui->custom_ecm_1->text();
  hex_to_str(ecm_text,custom_buf_a,1);
  custom_buf_a[1] = calc_msglength(length + 3);
  custom_buf_a[length + 2] = datastream::checksum_generate(custom_buf_a,length + 2);
  ui->custom_len_1->setText(QString::number(custom_buf_a[1],16).toUpper());
  ui->custom_cksum_1->setText(QString::number(custom_buf_a[length + 2],16).toUpper());
  control->custom_a.set(custom_buf_a);
}

void raw_command::custom_2_reload() {
  byte custom_buf_b[MAX_WRITE_BUF];
  QString main_text = ui->custom_msg_2->text();
  int length = main_text.length()/2;
  hex_to_str(main_text,custom_buf_b + 2,length);
  QString ecm_text = ui->custom_ecm_2->text();
  hex_to_str(ecm_text,custom_buf_b,1);
  custom_buf_b[1] = calc_msglength(length + 3);
  custom_buf_b[length + 2] = datastream::checksum_generate(custom_buf_b,length + 2);
  ui->custom_len_2->setText(QString::number(custom_buf_b[1],16).toUpper());
  ui->custom_cksum_2->setText(QString::number(custom_buf_b[length + 2],16).toUpper());
  control->custom_b.set(custom_buf_b);
}

void raw_command::on_idlemodscanbtn_clicked() {
  control->custom_idle.request();
}
