#ifndef DATALOG_PACKET_H
#define DATALOG_PACKET_H

#include "config.h"
#include "datalog.h"
#include "datalog_types.h"
#include "datalog_definition.h"

class datalog_definition;
class datalog_element;
class datalog;

class datalog_packet {
public:
  datalog_packet(datalog_definition *definition_in, datalog *log_in, int size_in);
  //--------------------
  timestamp_t timestamp;
  unsigned int sequence;
  datalog_definition *def;
  datalog *log;
  int size;
  //--------------------
  int get_int(int i);
  float get_float(int i);
  bool get_bool(int i);
  int get_int(const char *str);
  float get_float(const char *str);
  bool get_bool(const char *str);
  int get_int(datalog_element *e);
  float get_float(datalog_element *e);
  bool get_bool(datalog_element *e);
  int get_msgnumber();
  int get_device();
  bool is_msg(int device, int msg_no);
  //--------------------
  byte get_raw_byte(byte offset);
  void set_raw_byte(byte offset, byte input); // this wont work once attached to list.
  //----------------
  datalog_packet *get_next(int device, int msgnumber);
  datalog_packet *get_next();
  datalog_packet *get_latest();
  datalog_packet *get_prev(int device, int msgnumber);
  datalog_packet *get_prev();
  bool is_last_packet(int device, int msgnumber);
  bool is_last_packet();
  bool is_first_packet(int device, int msgnumber);
  //----------------
  bool is_attached();
  void set_attached();
  void detach();
  void set_next(datalog_packet *next_packet);
  void set_prev(datalog_packet *prev_packet);
  //----------------
  quint64 get_raw_checksum(); // for logfiles
private:
  bool attached;
  datalog_packet *prev;
  datalog_packet *next;
  QMutex lock_next;
  QMutex lock_prev;
  byte data[MAX_M1_DATA_SIZE];
};

#endif // DATALOG_PACKET_H
