#include "debuglog_window.h"
#include "ui_debuglog_window.h"

debuglog_window *debug_window_instance;

bool log_verbose;

debuglog_window::debuglog_window(QWidget *parent) :
  QWidget(parent),
  ui(new Ui::debuglog_window) {
  ui->setupUi(this);
  debug_window_instance = this;
  log_verbose = false;
}

debuglog_window::~debuglog_window() {
  delete ui;
}

void debuglog_window::append_log(QString str) {
  ui->debug_out->appendPlainText(str);
  if(ui->autoscroll->isChecked() == true) {
    QTextCursor c = ui->debug_out->textCursor();
    c.movePosition(QTextCursor::End);
    ui->debug_out->setTextCursor(c);
  }
}

void debuglog_window::on_copy_to_clipboard_clicked() {
  ui->debug_out->selectAll();
  ui->debug_out->copy();
}

//-----------

debuglog_controller::debuglog_controller() {
  // connect signal
  if(debug_window_instance == nullptr) return;
  connect(this,SIGNAL(send_log_append(QString)),
          debug_window_instance,SLOT(append_log(QString)));
}

bool debuglog_controller::verbose() {
  return log_verbose;
}

debuglog_controller::~debuglog_controller() {
  // connect signal
  if(debug_window_instance == nullptr) return;
  disconnect(this,SIGNAL(send_log_append(QString)),
          debug_window_instance,SLOT(append_log(QString)));
}

void debuglog_controller::print(QString log_message, unsigned char *c, int n) {
  QByteArray t;
  t.setRawData((char *)c,n);
  QString str;
  str.append(log_message);
  str.append("*");
  str.append(t.toHex().toUpper());
  emit(send_log_append(str));
}

void debuglog_controller::print(QString log_message) {
  emit(send_log_append(log_message));
}

void debuglog_controller::print_verbose(QString log_message) {
  if(verbose() == false) return;
  print(log_message);
}

void debuglog_controller::print_verbose(QString log_message, unsigned char *c, int n) {
  if(verbose() == false) return;
  print(log_message,c,n);
}

void debuglog_window::on_verbose_logging_toggled(bool checked) {
  log_verbose = checked;
}
