#ifndef SETTINGS_H
#define SETTINGS_H

#include <QSettings>
#include "config.h"

enum vehicle_type {
  VEHICLE_NONE,
  VEHICLE_F,
  VEHICLE_B,
  VEHICLE_Y
};

class eehack_settings {
public:
  eehack_settings();
  ~eehack_settings();
  enum {
    WB_SRC_AC,
    WB_SRC_D27
  };
  //--------------------
  bool get_wideband_enable();
  void set_wideband_enable(bool value);
  void set_wideband_src(int value);
  int get_wideband_src();
  bool get_wideband_smooth();
  void set_wideband_smooth(bool value);
  QString get_savepath();
  void set_savepath(QString value);
  bool get_analyze_wideband();
  //--------------------
  bool get_flash_skip();
  void set_flash_skip(bool value);
  bool get_flash_installpatch();
  void set_flash_installpatch(bool value);
  bool get_flash_low_latency();
  void set_flash_comparebin(QString value);
  QString get_flash_comparebin();
  //--------------------
  void clear();
  void set_serialport(QString value);
  QString get_serialport();
  double get_float(QString parameter, double value);
  double set_float(QString parameter, double value);
  bool get(QString parameter, bool value);
  bool set(QString parameter, bool value);
  int get(QString parameter, int value);
  int set(QString parameter, int value);
  bool get_display_blm_percent();
  bool get_display_kph();
  bool get_display_celcius();
  bool get_low_precision();
  bool get_low_percent_ok();
  bool get_graceful_disconnect();
  bool get_check_update();
  void set_check_update(bool value);
  bool get_async_display();
  void set_async_display(bool value);
  bool get_disable_patch();
  void set_disable_patch(bool value);
  void set_analyze_wideband(bool value);
  void set_m4_keepalive(bool value);
  bool get_m4_keepalive();
  void set_deffile(QString value);
  QString get_deffile();
  char *get_wb_str();
  bool get_always_draw();
  void set_always_draw(bool value);
  //--------------------
  int get_vehicle_type();
  void set_vehicle_type(int value);
  void set_silence_extra(bool value);
  bool get_silence_extra();
  bool get_first_run();
  bool get_warn_log();
  bool get_warn_notes();
  void set_warn_notes(bool value);
  void set_warn_log(bool value);
private:
  QString get_str(QString parameter, QString value);
  QString set_str(QString parameter, QString value);
  QSettings *settings;
};

#endif // SETTINGS_H

