#include <QApplication>
#include <QtDebug>

#include "datastream.h"
#include "datalog.h"
#include "stdlib.h"
#include "config.h"
#include "datalog_window.h"
#include "common.h"

int datastream::m3_get(byte addr_a, byte addr_b, byte side) {
  // construct packet
  set_device(side);
  set_mode(0x03);
  buf_out[3] = addr_a;
  buf_out[4] = addr_b;
  if(aldl_request_reply_length(6,5) == false) {
    return -9999;
  } else {
    return buf_in[3];
  }
}

bool datastream::m2_get(byte addr_a, byte addr_b, byte side) {
  // construct packet
  set_device(side);
  set_mode(0x02);
  buf_out[3] = addr_a;
  buf_out[4] = addr_b;
  if(aldl_request_reply_length(6,68) == false) {
    return false;
  } else {
    return true;
  }
}

bool datastream::m2_get_cp(int addr, byte side, byte *buf) {
  // construct packet - persistent bits
  set_device(side);
  set_mode(0x02);
  buf_out[3] = ( addr & 0xFF00) >> 8; // get high bits
  buf_out[4] = ( addr & 0x00FF); // get low bits
  if(aldl_request_reply_length(6,68) == false) return false;
  for(int x=0;x<64;x++) {
    buf[x] = buf_in[x + 3];
  }
  return true;
}

bool datastream::set_vin(QByteArray vin) {
  if(vin.length() != 17) return false;
  set_device(PRIMARY_ECM);
  set_mode(0x0C);
  buf_out[BMSG] = 0x01;
  for(int x=0;x<17;x++) { // cp byte array to buf
    buf_out[BMSG + 1 + x] = vin.at(x);
  }
  return aldl_request_reply_length(22,5,1000,75);
}

bool datastream::set_calid(quint32 calid) {
  byte calid_array[4];
  calid_array[0] = (calid >> 24) & 0xFF;
  calid_array[1] = (calid >> 16) & 0xFF;
  calid_array[2] = (calid >> 8) & 0xFF;
  calid_array[3] = calid & 0xFF;
  set_device(PRIMARY_ECM);
  set_mode(0x0C);
  buf_out[BMSG] = 0x02;
  for(int x=0;x<4;x++) { // cp byte array to buf
    buf_out[BMSG + 1 + x] = calid_array[x];
  }
  aldl_request_reply_length(9,5,1000,75);
  return true;
}

bool datastream::get_blm_cell_memory() {
  return m2_get(0x00,0x1c);
}

QByteArray datastream::process_blm_cell_memory() {
  QByteArray cell_data;
  cell_data.resize(38);
  for(int cell=0;cell<=18;cell++) {
    cell_data[cell] = buf_in[0x03 + cell];
    cell_data[cell + 19] = buf_in[0x03 + cell + 19];
  }
  return cell_data;
}


