#include "autotests.h"
#include "ui_autotests.h"
#include "common.h"

autotests::autotests(datastream_control *control_in, QWidget *parent) :
  QWidget(parent),
  ui(new Ui::autotests) {
  ui->setupUi(this);
  control = control_in;
}

autotests::~autotests() {
  delete ui;
}

void autotests::on_btn_snapshop_balance_clicked() {
  QString str;
  if(ui->cylStrProgress->value() < 13) return;
  str += "------------------\n";
  str += "CYLDROP Memo :: \n";
  str += "(Higher is better...)\n";
  str += QString("CYL1=%1 ").arg(ui->cyl1txt->text());
  str += QString("CYL2=%1\n").arg(ui->cyl2txt->text());
  str += QString("CYL3=%1 ").arg(ui->cyl3txt->text());
  str += QString("CYL4=%1\n").arg(ui->cyl4txt->text());
  str += QString("CYL5=%1 ").arg(ui->cyl5txt->text());
  str += QString("CYL6=%1\n").arg(ui->cyl6txt->text());
  str += QString("CYL7=%1 ").arg(ui->cyl7txt->text());
  str += QString("CYL8=%1 ").arg(ui->cyl8txt->text());
  emit send_new_note(str);
}

void autotests::on_runCylDropTest_clicked() {
  if(control->is_connected() == false) {
    emit error_dialog("Can't run the cylinder drop test while disconnected.");
    return; // drop here, as test would never run..
  }
  control->cyldroptest.request();
}

void autotests::display_cylbalance_progress(QString msg, int progress) {
  ui->displayCylTestState->setText(msg);
  ui->cylStrProgress->setValue(progress);
}

void autotests::display_cylbalance_result(int cylid, int max, float value) {
  QSlider *slider = nullptr;
  QLineEdit *line = nullptr;
  switch(cylid) {
  case 1:
    slider = ui->cyl1str;
    line = ui->cyl1txt;
    break;
  case 2:
    slider = ui->cyl2str;
    line = ui->cyl2txt;
    break;
  case 3:
    slider = ui->cyl3str;
    line = ui->cyl3txt;
    break;
  case 4:
    slider = ui->cyl4str;
    line = ui->cyl4txt;
    break;
  case 5:
    slider = ui->cyl5str;
    line = ui->cyl5txt;
    break;
  case 6:
    slider = ui->cyl6str;
    line = ui->cyl6txt;
    break;
  case 7:
    slider = ui->cyl7str;
    line = ui->cyl7txt;
    break;
  case 8:
    slider = ui->cyl8str;
    line = ui->cyl8txt;
    break;
  }
  if(line == nullptr) return; // invalid
  slider->setMaximum(max * 10);
  slider->setValue(value * 10);
  line->setText(QString("%1").number(value,'f',1));
}
