#ifndef BIN_FILE_H
#define BIN_FILE_H

#include <QApplication>

typedef unsigned char byte;

// stores an $EE memory dump and modifies it appropriately...
class bin_file {
public:
  enum _bin_side {
    TSIDE,
    ESIDE
  };
  bin_file();
  byte eside[0x10000];
  byte tside[0x10000];
  void zero_ram();
  bool test_checksum(byte *data);
  bool test_checksum();
  void reset_checksums();
  bool set_checksum(byte *data);
  bool compare_tside(bin_file comp);
  bool compare_eside(bin_file comp);
  bool copy_to(bin_file *cp);
  void zero_bin();
  bool apply_patches(); // apply all patches
  // file ops
  bool load_file(QString path);
  bool save_file(QString path);
  // patches
  int ff_unused_regions();
  bool patch_enhanced_logging();
  bool patch_afr_msg0();
  void set_patch_version();
  // patch utilities
  int fill_0xff(byte *data, int offset, int size);
  void install_patch(byte *bin, int offset, byte *patch, int size);
  bool compare_patch(byte *bin, int offset, byte *patch, int size);
  // bin info
  bool is_automatic_transmission();
  bool is_maf_enabled();
  bool is_data_in_blank_eside_region_a();
  bool is_data_in_blank_eside_region_b();
  bool is_tunercat_notes_blank();
  QString ecm_info_string();
  bool patch_eside_comms();
  bool is_null();
  // get/set
  void set_byte8(_bin_side side, int offset, byte value);
  void set_byte16(_bin_side side, int offset, quint16 value);
  byte get_byte8(_bin_side side, int offset);
  quint16 get_byte16(_bin_side side, int offset);
private:
  QString bool_to_enabled(bool x);
  QString bool_to_present(bool x);
};

#endif // BIN_FILE_H
