#ifndef LAUNCHER_H
#define LAUNCHER_H

#include <QDialog>
#include <QNetworkAccessManager>
#include <QNetworkRequest>
#include <QNetworkReply>
#include <QUrl>
#include <QMainWindow>

#include "datalog_window.h"
#include "datastream.h"
#include "datalog.h"
#include "settings.h"
#include "autospark.h"
#include "qcustomplot.h"
#include "notepad.h"
#include "debuglog_window.h"
#include "about_window.h"
#include "controller.h"
#include "settings_editor.h"
#include "autotests.h"
#include "raw_command.h"
#include "analyzer.h"
#include "update_notify.h"
#include "graphing.h"
#include "memory_ui.h"
#include "ui_mainwindow.h"

namespace Ui {
class MainWindow;
}

class MainWindow : public QMainWindow {
  Q_OBJECT

public:
  explicit MainWindow(QWidget *parent = 0);
  ~MainWindow();
  void on_interface_loaded();
signals:
  void enable_port_selection(bool);
  void recheck_version();
  void close_graphs();
public slots:
  void recieve_critical_error_msg(QString msg);
  void recieve_info_msg(QString msg);
  void recieve_connection_state(int c);
  void add_fail_count();
  void recieve_invalid_serial_port();
  void display_acqstatus(QString str);
  void reset_error_count();
  void check_version(int new_version);
  void recieve_fatal_error_msg(QString msg);
private slots:
  void on_btn_mode4_clicked();
  void on_btn_shownotes_clicked();
  void on_btn_debuglog_clicked();
  void on_btn_config_clicked();
  void on_connectButton_clicked();
  void on_btn_about_clicked();
  void on_btn_raw_clicked();
  void on_btn_tests_clicked();
  void on_btn_analyze_clicked();
  void run_acq_thread();
  void on_btn_graph_clicked();
  void on_btn_memio_clicked();

  void on_toolButton_toggled(bool checked);

  void on_btn_flash_clicked();

private:

  Ui::MainWindow *ui;
  settings_editor *settings_window;
  datastream *acqthread;
  notepad *notes;
  datalog *log;
  controller *mode4controller;
  debuglog_window *debugwin;
  datastream_control *control;
  datalog_window *datalog_win;
  analyzer_ui *analyzer_win;
  autotests *test_window;
  raw_command *raw_command_window;
  about_window *about_win;
  update_notify *update;
  datalog_definition *def;
  memory_ui *memio_win;
  int error_count;
  void kill_acqthread();
  float convert_version(int v);
  void launch_url(QString url);
  void init_debug_info();
  void closeEvent(QCloseEvent *x) override;
  void error_dialog(QString msg);
  void set_connstatus(QString status);
  void info_dialog(QString q);
  void display_error_count();
  QString current_version_string();
  void activate_module(QWidget *w);
  void bail_error(QString msg);
  void prepare_acqthread();
  void load_datastream_defs();
  void set_loading_status(QString str);
  bool loading_complete;
  void display_welcome_screen();
};

#endif // LAUNCHER_H
