#ifndef PARAMETER_SELECT_H
#define PARAMETER_SELECT_H

#include <QDialog>
#include <QListWidget>

#include "datalog_definition.h"
#include "datalog_element.h"
#include "datalog.h"

#define BASIC_VIEWLEVEL_STR "Basic"
#define EXTENDED_VIEWLEVEL_STR "Extended"
#define HACKER_VIEWLEVEL_STR "Hacker"

namespace Ui {
class parameter_select;
}

class parameter_select : public QDialog {
  Q_OBJECT

public:
  enum restriction_t {
    RESTRICT_NUM,
    RESTRICT_SWITCH,
    RESTRICT_NONE
  };

  explicit parameter_select(QWidget *parent, datalog_definition *def_in, datalog *log_in,
                            restriction_t restrict_type = RESTRICT_NONE,
                            datalog_definition *restrict_definition = nullptr);
  ~parameter_select();

  datalog_element *get_result();

private slots:
  void on_btn_cancel_clicked();
  void on_btn_select_clicked();
  void on_selector_message_currentIndexChanged(int);
  void on_selector_viewlevel_currentIndexChanged(int);
  void on_parameter_list_currentItemChanged(QListWidgetItem *current, QListWidgetItem *item_index);
  void on_parameter_list_doubleClicked(const QModelIndex);
  void on_parameter_filter_textChanged(const QString &arg1);

private:
  Ui::parameter_select *ui;
  datalog_definition *def;
  datalog *log; // ... mostly for patch versioning
  datalog_element *selected_element;
  datalog_element::VIEW_LEVEL get_view_level();
  void refresh();
  datalog_definition *get_selected_def();
  bool element_is_valid(datalog_element *e);
  int get_patch_level();
  void add_def_to_dropbox(datalog_definition *w_def);
  QRegExp filter;

  restriction_t restriction;
  bool qualify_element_type(datalog_element *x);
};

#endif // PARAMETER_SELECT_H
