#ifndef SAFETYPES_H
#define SAFETYPES_H

#include <QApplication>
#include <QMutex>
#include "config.h"
#include "datalog_types.h"

// This file defines a bunch of thread safe classes with built-in locking and junk.
// atomic types such as bool and int are also provided with functions for readability...

class safe_switch : public QObject {
  Q_OBJECT
public:
  safe_switch();
  void request();
  bool get();
  bool is_set();
  void unset();
  void disable();
  void enable();
  void set(bool in);
  bool getclear(); // clears the bit after getting it
private:
  bool setting;
};

class safe_int : public QObject {
  Q_OBJECT
public:
  safe_int();
  int get();
  void set(int in);
private:
  qint32 setting;
};

class safe_string : public QObject {
  Q_OBJECT
public:
  safe_string();
  QString get();
  void set(QString in);
private:
  QMutex m;
  QString setting;
};

class safe_raw_command : public QObject {
public:
  safe_switch send; // submit flag
  safe_int postdelay;
  safe_switch loop;
  void set(byte *buf_in);
  void get(byte *buf_out);
private:
  QMutex m;
  byte cmd[MAX_WRITE_BUF];
};

#endif // SAFETYPES_H
