#ifndef DATALOG_ELEMENT_H
#define DATALOG_ELEMENT_H

#include "datalog_types.h"
#include "datalog_packet.h"
#include "datalog_definition.h"
#include "settings.h"
#include "config.h"

class datalog_packet;
class datalog_definition;

enum def_special_t {
  DEF_SPECIAL_NONE = 0,
  DEF_SPECIAL_TRIM, // this is unsigned raw trim
  DEF_SPECIAL_CELCIUS,
  DEF_SPECIAL_MPH,
  DEF_SPECIAL_KPA,
  DEF_SPECIAL_RPMMINOR, // rpm minor loop special calc
  DEF_SPECIAL_WIDEBAND, // is a wideband input
  DEF_SPECIAL_SHIFTPOS, // convert 2nd and 3rd bits (sol pos) to current gear
  DEF_SPECIAL_RESEARCH, // when displaying, display hex and binary too
  DEF_SPECIAL_ASCII, // is an ascii string of bit length
  DEF_SPECIAL_SIGNED, // is signed
  DEF_SPECIAL_ECONOMY, // is the special fuel economy field
  DEF_SPECIAL_AVERAGE // output the average of this and the next byte
};

class datalog_element {
public:
  datalog_element(int offset_in, datalog_definition *parent_in);
  datalog_element *next;
  //---------------
  enum VIEW_LEVEL { VIEW_HIDDEN = -99,
                    VIEW_ERROR = -1, VIEW_VERROR = -2,
                    VIEW_HACKER = 0, VIEW_EXTENDED = 1, VIEW_BASIC = 2
                     };
  //---------------
  int get_int(datalog_packet *p);
  int get_raw(datalog_packet *p);
  float get_float(datalog_packet *p);
  float get_float_from_value(int value);
  bool get_bool(datalog_packet *p);
  QString get_ascii(datalog_packet *p);
  QString get_string(datalog_packet *p, bool sparse = false);
  //---------------
  bool is_float();
  bool is_int();
  bool is_bool();
  bool is_associated(datalog_packet *p);
  //---------------
  int offset;
  char short_name[MAX_SHORTNAME_LENGTH];
  QString long_name;
  QString uom;
  QString full_title();
  VIEW_LEVEL level;
  int size;
  int precision; // doubles as bitfield
  byte min_patch;
  byte max_patch;
  float eq_add;
  float eq_mult;
  def_special_t special;
  datalog_definition *def;
  int convert_signed(int x);
  //---------------
  float warn_low;
  float warn_high;
  bool is_low(datalog_packet *p);
  bool is_high(datalog_packet *p);
  //---------------
  float range_min;
  float range_max;
  float get_range_min();
  float get_range_max();
  void calc_high_range();
  void calc_low_range();
  //---------------
  bool matches_patchlvl(byte patchlvl);
  bool uom_is(QString x); // is the unit of measure the same as __
  //---------------
  QString describe();
private:
  float trim_to_percent(int trim);
  QString percent_to_str(double x);
  float economy(datalog_packet *p);
};


#endif // DATALOG_ELEMENT_H
