#include <QMessageBox>
#include <QFileDialog>
#include <QTextStream>
#include "notepad.h"
#include "ui_notepad.h"
#include "settings.h"

notepad::notepad(QWidget *parent) :
  QWidget(parent),
  ui(new Ui::notepad) {
  ui->setupUi(this);
  memo_changed = false;
}

notepad::~notepad() {
  delete ui;
}

void notepad::append_memo(QString str) {
  ui->memo_editor->appendPlainText(str);
  memo_changed = true;
}

void notepad::on_clear_btn_clicked() {
  ui->memo_editor->clear();
  memo_changed = false;
}

void notepad::on_save_btn_clicked() {
  save_memos();
}

void notepad::save_memos() {
  eehack_settings config;
  QString filename = QFileDialog::getSaveFileName(
        this,tr("Select TXT save path/name"),
        config.get_savepath(),tr("TXT File (*.txt)"));
  QFile f(filename);
  f.open( QIODevice::WriteOnly );
  if(f.isWritable() == false) {
    info_dialog("Could not open file for writing.");
    return;
  }
  QTextStream txt_out(&f);
  txt_out << ui->memo_editor->toPlainText();
  f.close();
  memo_changed = false;
}

void notepad::info_dialog(QString q) {
  QMessageBox msgBox;
  msgBox.setText(q);
  msgBox.exec();
}

void notepad::on_memo_editor_textChanged() {
  memo_changed = true;
}

bool notepad::handle_unsaved_data() {
  if(memo_changed == false) return true;
  if(ui->memo_editor->toPlainText().length() < 2) return true;
  int ret = QMessageBox::warning(this, tr("EEHack"),
                                 tr("There are unsaved notes in the notepad!\n"
                                    "Do you want to save them to a text file?"),
                                 QMessageBox::Save | QMessageBox::Discard
                                 | QMessageBox::Cancel,
                                 QMessageBox::Discard);
  if(ret == QMessageBox::Save) {
    save_memos();
    return true;
  }
  if(ret == QMessageBox::Discard) return true;
  if(ret == QMessageBox::Cancel) return false;
  return true; // never reached
}

void notepad::enable_controls(bool enable) {
  ui->save_btn->setEnabled(enable);
}

void notepad::add_new_note(QString str) {
  append_memo(str);
}
