#ifndef DATALOG_DEFINITION_H
#define DATALOG_DEFINITION_H

#include "datalog_types.h"
#include "datalog_element.h"
#include "settings.h"
#include "safetypes.h"

enum {
  DEF_FORMAT_FIELD_OFFSET = 0,
  DEF_FORMAT_FIELD_SHORTNAME,
  DEF_FORMAT_FIELD_LONGNAME,
  DEF_FORMAT_FIELD_UOM,
  DEF_FORMAT_FIELD_VIEWLEVEL,
  DEF_FORMAT_FIELD_SIZE,
  DEF_FORMAT_FIELD_PRECISION,
  DEF_FORMAT_FIELD_MULT,
  DEF_FORMAT_FIELD_ADD,
  DEF_FORMAT_FIELD_MINPATCH,
  DEF_FORMAT_FIELD_MAXPATCH,
  DEF_FORMAT_FIELD_SPECIAL,
  DEF_FORMAT_FIELD_WARNLOW,
  DEF_FORMAT_FIELD_WARNHIGH,
  DEF_FORMAT_FIELD_RANGELOW,
  DEF_FORMAT_FIELD_RANGEHIGH,
  DEF_FORMAT_NFIELDS
};

enum {
  DEF_HEADER_FIELD_SPECIFIER = 0,
  DEF_HEADER_FIELD_DEVICE,
  DEF_HEADER_FIELD_MSGNUMBER,
  DEF_HEADER_FIELD_COMMENT,
  DEF_HEADER_FIELD_NFIELDS
};

class datalog_element;
class datalog_packet;

class datalog_definition {
public:
  datalog_definition();
  datalog_element *attach_element(datalog_element *e);
  datalog_element *get_first_element();
  datalog_element *get_last_element();
  //----------
  datalog_definition *next_def; // forms a *circular* linked list among elements
  safe_switch acq;  // set to enable acquire
  safe_switch loop; // set to acquire repeatedly
  //----------
  bool is_empty(); // has a definition been loaded into this
  byte any_acq_enabled(); // are any definitions flagged for acqusition?
  datalog_definition *next_acq_def(); // get next definition flagged for acquisition or nullptr if all disabled
  datalog_definition *get_msg_number(byte device, byte msg);
  //----------
  bool load_definition_line(QString line_in);
  bool setup(QString line_in);
  QString msg_desc;
  //----------
  datalog_element *element_by_index(int i);
  datalog_element *element_by_name(const char *name);
  bool element_exists(const char *name);
  byte get_msg_number();
  byte get_device();
  //----------
  QString parseerr;
  //----------
  eehack_settings config;
  //----------
  bool err_elements_exist(byte patchlvl);
  bool errors_occurred(datalog_packet *p, byte patchlvl);
  QString err_str(datalog_packet *p, byte patchlvl);
  unsigned int n_errors(byte patchlvl);
  //----------
  void config_wideband(float adder, float multiplier, bool enable);
  void disable_wideband();
  //----------
  safe_int frequency;
  int n_passes;
private:
  byte msg_number;
  byte device_addr;
  byte msg_length;
  datalog_element *element;
  void parsing_error(QString str);
  //----------
};

#endif // DATALOG_DEFINITION_H
