#ifndef CONFIG_H
#define CONFIG_H

#include <qglobal.h>

// versioning
#define VERSION_CODE 493
//#define BETA_VERSION
#define EEHACK_UPDATE_URL "http://fbodytech.com/eehack-version.txt"

// welcome message (one time only)
#define WELCOME_STR "You will now be taken to the settings dialog.\nBe sure to set your vehicle type and serial port, and review the other options... The settings in red are the most important.\nHover your mouse over an option to get more info on it, both in the settings dialog and elsewhere in EEHack."

// current patch version for versioning against the ecm bin.
#define CURRENT_PATCH_VERSION 0x03

// the cpu throttling sleep timer in milliseconds.  lower takes more cpu time unnecessarily,
// too high could cause data rates to lower...
// internally, this is added to and multiplied, but never lowered.  requires a value of at least '1'.
#define THROTTLE_MS 2

// input/output fixed buffer sizes
#define MAX_READ_BUF 1024
#define MAX_WRITE_BUF 512

// how long (in ms) will we wait for a broadcast
#define BROADCAST_WAIT_TIME 2000

// low long to clear garbage after a silence request
#define SHUTUP_CLEARING_TIME 100

// how many milliseconds before the ECM forgets we've been chatting
#define MAX_ECM_SHUTUP_TIME 2200
#define M4_RESEND_INTERVAL 25

// maximum and minimum "serial noise" collection threshold in milliseconds
// before sending a request, we can wait for a bit to collect any extra bytes left over
// from previous synchronization errors.
// in a properly synchronized datastream this is unnecessary and slows packet rates
// this allows a dynamic garbage collection time, if errors occur, the time increases
// and if no errors occur, the time decreases.  this eases recovery from errors while
// accelerating data rates in ideal circumstances.
#define GARBAGE_COLLECTION_MAXTIME 15
#define GARBAGE_COLLECTION_MINTIME 0

// ignore annoying vc++ warning
//#pragma warning(disable: 4100)

// steps added to iac for cyl drop test
#define CYLDROP_IDLE_ADDER 30

// this is the length of the rpm averaging test for each cylinder
#define CYL_DROP_TESTLENGTH 12

// reset connection after this many sequential failed packets
#define MAX_FAIL_PKTS 6

#define SETTINGS_DOMAIN "EEHackB", "fbodytech.com"

// flash specs
#define FLASH_WRITE_MAX_RETRIES 5
#define FLASH_WRITE_MAX_RESTARTS 8
#define FLASH_WRITE_POST_DELAY_SAFE 100
#define DEFAULT_WRITE_BLOCK_SIZE 0x9E
#define FLASH_WRITE_POST_DELAY_LONG 50
#define FLASH_WRITE_POST_DELAY_SHORT 12
#define FLASH_MIN_RST_TIME 10000

// above or below this percentage is considered irrelavent
#define DISCARD_TRIM 1

// filter strength for wideband analyzer.  transitions greater than this per single record are rejected.
#define WB_FILTER_STR 2.00

// how many records to average for wideband display
#define WB_SMOOTH_DEPTH 8

// log limits so stuff doesn't go haywire
#define LOG_TIMESTAMP_LIMIT (1000 * 60 * 24 * 8)

// time gap between records
#define MAX_TIMESTAMP_GAP 120000
#define MIN_TIMESTAMP_GAP 5
#define DEFAULT_TIMESTAMP_GAP 120000

// playback rate limits
#define MIN_DATALOG_PLAYBACK_GAP 20
#define MAX_DATALOG_PLAYBACK_GAP 5000

// colors
#define ENABLE_DATALOG_INDICATORS
#define INDICATOR_GREEN 75,200,75
#define INDICATOR_NEUTRAL 180,180,180
#define INDICATOR_RED 200,75,75
#define INDICATOR_STYLE_GREEN "background-color: rgb(75,200,75)"
#define INDICATOR_STYLE_RED "background-color: rgb(200,75,75)"
#define INDICATOR_STYLE_NEUTRAL "background-color: rgb(180,180,180)"
//#define INDICATOR_STYLE_GREEN "font: 8pt \"Verdana\"; background-color: rgb(75,200,75)"
//#define INDICATOR_STYLE_RED "font: 8pt \"Verdana\"; background-color: rgb(200,75,75)"
//#define INDICATOR_STYLE_NEUTRAL "font: 8pt \"Verdana\"; background-color: rgb(180,180,180)"

// packet size.  this is fixed.  you can't recieve or define parameters for messages larger than this.
// this is also a fundamental log format variable !!!
// if you generate a log with a higher max_m1_data_size then currently defined, the log will refuse
// to load.  this means we can increase it for future versions at the expense of obseleting old logs.
#define MAX_M1_DATA_SIZE 101

// what we call the currently unsaved 'recording' log
#define RECORDED_DATA_LOGNAME "Recorded Data"

// misc -- don't break this stuff!
#define MAX_MODE1_MESSAGES 12
#define MAX_LOG_LENGTH 1000000
#define MULT_LINEAR_5V 0.0196078431372549
#define LOG_MAGIC_NUMBER 0xEE0022AA
#define MAX_SHORTNAME_LENGTH 18

// affects the size of a knock display circle.
#define ANALYZER_KNOCK_COUNT_DIVISOR 50
#define ANALYZER_KNOCK_MIN_CIRCLE 3
#define ANALYZER_KNOCK_MAX_CIRCLE 24

#endif // CONFIG_H

