#include <QApplication>
#include <QMainWindow>
#include <QThread>
#include <QDebug>

#include "safetypes.h"
#include "common.h"

safe_switch::safe_switch() {
  setting = false;
}

void safe_switch::request() {
  set(true);
}

bool safe_switch::get() {
  return setting;
}

bool safe_switch::is_set() {
  return get();
}

void safe_switch::unset() {
  set(false);
}

void safe_switch::disable() {
  set(false);
}

bool safe_switch::getclear() {
  // FIXME needs locking
  bool tmp = setting;
  setting = false;
  return tmp;
}

void safe_switch::set(bool in) {
  setting = in;
}

void safe_switch::enable() {
  set(true);
}

safe_string::safe_string() {

}

QString safe_string::get() {
  m.lock();
  QString tmp = setting;
  m.unlock();
  return tmp;
}

void safe_string::set(QString in) {
  m.lock();
  QString cp(in);
  setting = cp;
  m.unlock();
}

void safe_raw_command::set(byte *buf_in) {
  m.lock();
  for(int x=0;x<MAX_WRITE_BUF;x++) cmd[x] = buf_in[x];
  m.unlock();
}

void safe_raw_command::get(byte *buf_out) {
  m.lock();
  for(int x=0;x<MAX_WRITE_BUF;x++) buf_out[x] = cmd[x];
  m.unlock();
}

safe_int::safe_int() {
  setting = 0;
}

int safe_int::get() {
  return setting;
}

void safe_int::set(int in) {
  setting = in;
}
