#ifndef AUTOTESTS_H
#define AUTOTESTS_H

#include <QWidget>
#include "datastream.h"

namespace Ui {
class autotests;
}

class autotests : public QWidget
{
  Q_OBJECT

public:
  explicit autotests(datastream_control *control_in, QWidget *parent = 0);
  ~autotests();

private:
  Ui::autotests *ui;
  datastream_control *control;

public slots:
  void display_cylbalance_result(int cylid, int max, float value);
  void display_cylbalance_progress(QString msg, int progress);

signals:
  void info_dialog(QString);
  void error_dialog(QString);
  void send_new_note(QString);
private slots:
  void on_runCylDropTest_clicked();
  void on_btn_snapshop_balance_clicked();
};

#endif // AUTOTESTS_H
