#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QApplication>
#include <QDialog>
#include "ui_datalog_window.h"
#include "datastream.h"
#include "datalog.h"
#include "settings.h"
#include "qcustomplot.h"
#include "controller.h"
#include "datalog_extended.h"

namespace Ui {
class datalog_window;
}

enum indicator_ {
  COLOR_GOOD,
  COLOR_BAD,
  COLOR_NEUTRAL
};

class dashboard_field {
public:
  explicit dashboard_field(QLineEdit *field_in, datalog_element *element_in, bool is_indicator = false);
  //------
  void draw(datalog_packet *pkt);
  void draw_all(datalog_packet *pkt); // call on first list member to recurse draw all
  dashboard_field *get_last();
  dashboard_field *next;
  void configure_element(datalog_element *element_in);
private:
  //------
  QLineEdit *widget;
  //------
  datalog_element *main_element;
  datalog_element *speedlog_element;
  void display_bool(bool value);
  void display_str(QString str, QString style = QString());
  bool cache_bool;
  QString cache_str;
  bool indicator;
};

class datalog_window : public QWidget {
  Q_OBJECT

public:
  //--------------------
  explicit datalog_window(datastream_control *control_in, datalog *log_in, datalog_definition *def_in, QWidget *parent = 0);
  ~datalog_window();
  void on_interface_loaded();
  bool handle_unsaved_data();
  datalog *get_active_log_ptr();

  void set_closing();
  bool ok_to_close();

private slots:
  //--------------------
  void on_clear_dtc_btn_clicked();
  void on_setvin_btn_clicked();
  //--------------------
  void on_getecminfo_btn_clicked();
  //--------------------
  void on_restart_log_btn_clicked();
  void on_export_data_btn_clicked();
  void on_import_data_btn_clicked();
  //--------------------
  void on_btn_beginning_clicked();
  void on_btn_stepback_clicked();
  void on_btn_play_clicked();
  void on_btn_stepforward_clicked();
  void on_btn_end_clicked();
  void on_time_slider_valueChanged(int value);
  //--------------------
  void on_setcal_btn_clicked();
  //--------------------
  void on_mainTabSwitcher_currentChanged(int index);
  void on_vinnumber_display_textChanged(const QString);
  void on_calid_display_textChanged(const QString);
  void on_active_log_selector_currentIndexChanged(const QString &arg1);
  void display_dashboard_worker();
  //--------------------
  void on_btn_dash_user_a_clicked();
  void on_btn_dash_user_b_clicked();
  void on_btn_dash_user_c_clicked();
  void on_btn_dash_user_d_clicked();
  void advance_playback_pkt();

public slots:
  void recieve_new_packet(datalog_packet *display_pkt);
  void recieve_new_pktrate(float rate);
  void recieve_connection_state(int c);
  void recieve_new_ecm_info();
  void display_config_changed();
  void change_log_position(double position);

signals:
  void add_new_note(QString);
  void display_info_dialog(QString);
  void display_error_dialog(QString);
  void display_new_packet(datalog_packet *packet);
  void display_config_changed_();
  void patch_level_changed_(int patchlvl);
  void active_log_changed(datalog *new_log);
  void log_position_changed(double);

private:
  //--------------------
  Ui::datalog_window *ui;
  //--------------------
  eehack_settings config;
  datastream_control *control;
  datalog *log;
  datalog_packet *playback_pkt;
  datalog_packet *dashboard_pkt;
  datalog_definition *def;
  dashboard_field *dashboard;
  datalog_extended *ext[MAX_MODE1_MESSAGES];
  //--------------------
  void parameter_text_display(QWidget *widget, float i, int precision, QString uom);
  void parameter_text_display(QWidget *widget, int i, QString uom);
  void parameter_text_display(QWidget *widget, float i, int precision);
  void parameter_text_display(QWidget *widget, int i);
  void parameter_indicator_display(QWidget *widget, bool i);
  void parameter_err_display(QWidget *widget, bool i);
  void parameter_text_display(QWidget *widget, QString str);
  void qtextedit_bgcolor(QWidget *widget, int r, int g, int b);
  //--------------------
  void unblock_ui();
  //--------------------
  void set_interface_connstate(bool connected); // disable/enable buttons based on conn state
  //--------------------
  void info_dialog(QString q); // pop-up dialog
  //--------------------
  void display_dashboard();
  //--------------------
  bool slider_canary;
  bool unsaved_log;
  //--------------------
  bool save_raw_file(datalog *log_out);
  QString get_save_filename(QString extension, QString type_name);
  QStringList get_log_select_dialog();
  bool load_raw_file(QString filename, datalog *new_log);
  //--------------------
  void append_memo(QString str);
  //--------------------
  void move_to_record(datalog_packet *p);
  void start_playback();
  void stop_playback();
  bool playback_status;
  //--------------------
  bool calid_validate();
  bool vin_validate();
  void set_patch_version_display();
  //--------------------
  // for wideband display smoothing
  float wb_cache[WB_SMOOTH_DEPTH];
  int wb_cache_population;
  int wb_cache_depth;
  void wb_reset_cache();
  float wb_get_cache(float wbafr);
  //--------------------
  void clear_running_log();
  QString last_save_filename;
  void update_pktcount();
  QTimer *playback_timer;
  void lineedit_indicator_display(QLineEdit *edit, bool i);
  void lineedit_error_display(QLineEdit *edit, bool i);
  //--------------------
  void add_log_to_logselector(datalog *d);
  void load_log_from_file(QString filename);
  void add_new_log(datalog *new_log);
  void update_ecm_info();
  void error_dialog(QString q);
  void update_datalog_context();
  bool draw_in_progress;
  //--------------------
  void config_dashboard();
  void move_dashboard(datalog_packet *p);
  dashboard_field *dash_add_field(QLineEdit *displ, datalog_element *element_in);
  dashboard_field *dash_add_indicator(QLineEdit *displ, const char *parameter_name);
  dashboard_field *dash_add_field(QLineEdit *displ, const char *parameter_name);
  //--------------------
  void set_user_parameter(QLabel *label, dashboard_field *dashfield);
  dashboard_field *dash_user_a;
  dashboard_field *dash_user_b;
  dashboard_field *dash_user_c;
  dashboard_field *dash_user_d;
  dashboard_field *dash_wideband;
  //--------------------
  void create_extended_tabs();
  bool load_old_file(QString filename, datalog *new_log);
};

#endif // MAINWINDOW_H
