#ifndef SETTINGS_EDITOR_H
#define SETTINGS_EDITOR_H

#include <QDialog>
#include "settings.h"
#include "datastream.h"

namespace Ui {
class settings_editor;
}

class settings_editor : public QWidget {
  Q_OBJECT

public:
  explicit settings_editor(datastream_control *control_in, datalog_definition *def_in, QWidget *parent = 0);
  ~settings_editor();
  void on_interface_loaded();
  bool select_deffile();
public slots:
  void enable_port_selection(bool value);
  void get_update_status(QString str);
private:
  eehack_settings config;
  datastream_control *control;
  Ui::settings_editor *ui;
  datalog_definition *def;
  void get_wideband_config();
  void set_wideband_parameters();
  void set_wb_src(int value);
  void process_port_list();
  bool select_port_from_list(QString port_name);
  void reset_all_settings();
  void get_all_settings();
  void get_config_misc();
signals:
  void display_config_changed();
  void datastream_config_changed();
  void update_recheck_requested();
private slots:
  void on_wb_use_ac_toggled(bool checked);
  void on_wb_use_d27_toggled(bool checked);
  void on_wb_low_afr_valueChanged(double arg1);
  void on_wb_high_voltage_valueChanged(double arg1);
  void on_wb_high_afr_valueChanged(double arg1);
  void on_wb_trim_valueChanged(double arg1);
  void on_wb_preset_fast_e85_clicked();
  void on_wb_preset_fast_gas_2_clicked();
  void on_wb_preset_fast_gas_3_clicked();
  void on_wb_preset_fast_gas_clicked();
  void on_setting_warn_log_toggled(bool checked);
  void on_setting_warn_notes_toggled(bool checked);
  void on_setting_disable_patch_toggled(bool checked);
  void on_setting_graceful_disconnect_toggled(bool checked);
  void on_setting_smooth_wb_toggled(bool checked);
  void on_refreshPortsBtn_clicked();
  void on_reset_settings_btn_clicked();
  void on_serialPortSelect_currentIndexChanged(const QString &arg1);
  void on_btn_save_dir_clicked();
  void on_setting_display_percent_toggled(bool checked);
  void on_setting_display_celcius_toggled(bool checked);
  void on_setting_display_kph_toggled(bool checked);
  void on_setting_display_low_percent_ok_toggled(bool checked);
  void on_setting_display_low_precision_toggled(bool checked);
  void on_setting_enable_wideband_toggled(bool checked);
  void on_update_force_check_clicked();
  void on_setting_check_update_toggled(bool checked);
  void on_setting_m4keepalive_toggled(bool checked);
  void on_btn_set_deffile_clicked();
  void on_setting_extra_mods_toggled(bool checked);
  void on_setting_alwaysdraw_toggled(bool checked);
  void on_setting_async_display_toggled(bool checked);
};

#endif // SETTINGS_EDITOR_H
