#ifndef DEBUGLOG_WINDOW_H
#define DEBUGLOG_WINDOW_H

#include <QDialog>

namespace Ui {
class debuglog_window;
}

class debuglog_window : public QWidget {
  Q_OBJECT
public:
  explicit debuglog_window(QWidget *parent = 0);
  ~debuglog_window();
private slots:
  void on_copy_to_clipboard_clicked();
  void on_verbose_logging_toggled(bool checked);

public slots:
  void append_log(QString str);
private:
  Ui::debuglog_window *ui;
  bool verbosity;
};

class debuglog_controller : public QObject {
  Q_OBJECT
public:
  debuglog_controller();
  ~debuglog_controller();

  void print(QString log_message, unsigned char *c, int n);
  void print(QString log_message);

  void print_verbose(QString log_message);
  void print_verbose(QString log_message, unsigned char *c, int n);

  bool verbose();
signals:
  void send_log_append(QString);
};

#endif // DEBUGLOG_WINDOW_H
