#include <QSettings>

#include "settings_editor.h"
#include "config.h"
#include "datalog.h"
#include "common.h"

eehack_settings::eehack_settings() {
  settings = new QSettings(SETTINGS_DOMAIN);
}

eehack_settings::~eehack_settings() {
  delete settings;
}

// get/set functions

bool eehack_settings::get(QString parameter, bool value) {
  if(settings->contains(parameter) == false) { // set default
    set(parameter,value);
    return value;
  } else { // return value
    return settings->value(parameter).toBool();
  }
}

bool eehack_settings::set(QString parameter, bool value) {
  settings->setValue(parameter,value);
  return value;
}

int eehack_settings::get(QString parameter, int value = 0) {
  if(settings->contains(parameter) == false) { // set default
    set(parameter,value);
    return value;
  } else { // return value
    return settings->value(parameter).toInt();
  }
}

int eehack_settings::set(QString parameter, int value) {
  settings->setValue(parameter,value);
  return value;
}

double eehack_settings::get_float(QString parameter, double value = 0) {
  if(settings->contains(parameter) == false) { // set default
    set_float(parameter,value);
    return value;
  } else { // return value
    return settings->value(parameter).toDouble();
  }
}

double eehack_settings::set_float(QString parameter, double value) {
  settings->setValue(parameter,(double)value);
  return value;
}

QString eehack_settings::get_str(QString parameter, QString value) {
  if(settings->contains(parameter) == false) { // set default
    set_str(parameter,value);
    return value;
  } else { // return value
    return settings->value(parameter).toString();
  }
}

QString eehack_settings::set_str(QString parameter, QString value) {
  settings->setValue(parameter,value);
  return value;
}

void eehack_settings::clear() {
  settings->clear();
}

// vehicle type

int eehack_settings::get_vehicle_type() {
  return get("VEHICLE_TYPE",VEHICLE_F);
}

void eehack_settings::set_vehicle_type(int value) {
  set("VEHICLE_TYPE",value);
}

// wideband

bool eehack_settings::get_wideband_enable() {
  return get("WIDEBANDENABLE",false);
}

void eehack_settings::set_wideband_enable(bool value) {
  set("WIDEBANDENABLE",value);
}

bool eehack_settings::get_wideband_smooth() {
  return get("WIDEBANDSMOOTH",true);
}

void eehack_settings::set_wideband_smooth(bool value) {
  set("WIDEBANDSMOOTH",value);
}

int eehack_settings::get_wideband_src() {
  return get("WIDEBANDSRC",WB_SRC_AC);
}

void eehack_settings::set_wideband_src(int value) {
  set("WIDEBANDSRC",value);
}

char *eehack_settings::get_wb_str() {
  static char wb_src_names[2][MAX_SHORTNAME_LENGTH] = { "WIDEBAND_AC", "WIDEBAND_D27" };
  return wb_src_names[get_wideband_src()];
}

bool eehack_settings::get_always_draw() {
  return get("ALWAYS_DRAW_DASHBOARD",true);
}

void eehack_settings::set_always_draw(bool value) {
  set("ALWAYS_DRAW_DASHBOARD",value);
}

// save dir

void eehack_settings::set_savepath(QString value) {
  set_str("SAVEPATH",value);
}

QString eehack_settings::get_savepath() {
  return get_str("SAVEPATH","");
}

// definition file

void eehack_settings::set_deffile(QString value) {
  set_str("DEF_FILE",value);
}

QString eehack_settings::get_deffile() {
  return get_str("DEF_FILE","ee_definition.csv");
}

// compare bin

void eehack_settings::set_flash_comparebin(QString value) {
  set_str("COMPAREBIN",value);
}

QString eehack_settings::get_flash_comparebin() {
  return get_str("COMPAREBIN","");
}

// serial port

void eehack_settings::set_serialport(QString value) {
  set_str("SERIALPORT",value);
}

QString eehack_settings::get_serialport() {
  return get_str("SERIALPORT","");
}

// misc

bool eehack_settings::get_display_blm_percent() {
  return get("DISPLAY_BLM_PERCENT",false);
}

bool eehack_settings::get_flash_low_latency() {
  return get("FLASH_LOW_LATENCY",true);
}

bool eehack_settings::get_display_kph() {
  return get("DISPLAY_KPH",false);
}

bool eehack_settings::get_display_celcius() {
  return get("DISPLAY_CELCIUS",true);
}

bool eehack_settings::get_low_precision() {
  return get("LOW_PRECISION",true);
}

bool eehack_settings::get_low_percent_ok() {
  return get("LOW_PERCENT_OK",true);
}

bool eehack_settings::get_graceful_disconnect() {
  return get("GRACEFUL_DISCONNECT",true);
}

bool eehack_settings::get_check_update() {
  return get("UPDATE_CHECK",true);
}

void eehack_settings::set_check_update(bool value) {
  set("UPDATE_CHECK",value);
}

void eehack_settings::set_async_display(bool value) {
  set("ASYNC_DISPLAY",value);
}

bool eehack_settings::get_async_display() {
  return get("ASYNC_DISPLAY",true);
}

bool eehack_settings::get_disable_patch() {
  return get("DISABLE_PATCH",false);
}

void eehack_settings::set_disable_patch(bool value) {
  set("DISABLE_PATCH",value);
}

bool eehack_settings::get_analyze_wideband() {
  return get("ANALYZE_WIDEBAND",false);
}

bool eehack_settings::get_flash_skip() {
  return get("FLASH_SKIP_UNUSED",true);
}

void eehack_settings::set_flash_skip(bool value) {
  set("FLASH_SKIP_UNUSED",value);
}

bool eehack_settings::get_flash_installpatch() {
  return get("FLASH_INSTALL_PATCH",true);
}

void eehack_settings::set_flash_installpatch(bool value) {
  set("FLASH_INSTALL_PATCH",value);
}

void eehack_settings::set_analyze_wideband(bool value) {
  set("ANALYZE_WIDEBAND",value);
}

void eehack_settings::set_m4_keepalive(bool value) {
  set("M4KEEPALIVE",value);
}

bool eehack_settings::get_m4_keepalive() {
  return get("M4KEEPALIVE",false);
}

void eehack_settings::set_silence_extra(bool value) {
  set("SILENCEEXTRAMODS",value);
}

bool eehack_settings::get_silence_extra() {
  return get("SILENCEEXTRAMODS",true);
}

bool eehack_settings::get_first_run() {
  bool is_first_run = get("FIRSTRUN_A",true);
  if(is_first_run == true) {
    set("FIRSTRUN_A",false); // clear
    return true;
  } else {
    return false;
  }
}

bool eehack_settings::get_warn_log() {
  return get("WARN_LOG",true);
}

bool eehack_settings::get_warn_notes() {
  return get("WARN_NOTES",true);
}

void eehack_settings::set_warn_notes(bool value) {
  set("WARN_NOTES",value);
}

void eehack_settings::set_warn_log(bool value) {
  set("WARN_LOG",value);
}
