#include <QMessageBox>
#include "general.h"

QStringList split_csv_line(QString in, bool process_quotes, bool process_backslashes) {
  QStringList out;
  int length = in.size();
  bool inside_quotes = false;
  bool backslashed = false;
  QString f; // current working field
  for(int x=0;x<length;x++) {
    if(inside_quotes == true) { // already in quote mode
      if(in[x] == '"') {
        inside_quotes = false; // end of quote mode
      } else {
        f.append(in[x]);
      }
    } else if(backslashed == true) { // last char was a backslash
      f.append(in[x]); // indiscriminate append
      backslashed = false;
    } else if(in[x] == '"' && process_quotes == true) {
      inside_quotes = true; // enter quote mode
    } else if(in[x] == '\\' && process_backslashes == true) {
      backslashed = true;
    } else if(in[x] == ',' || in[x] == '\r' || in[x] == '\n') {
      out.append(f); // add to list
      f.clear();
    } else {
      f.append(in[x]);
    }
  }
  out.append(f); // add last line to list
  return out;
}

double highest_of(double a, double b) {
  if(b > a) return b;
  return a;
}

double clamp(double value, double min, double max) {
  if(value > max) return max;
  if(value < min) return min;
  return value;
}

void fatal_error(QString errmsg) {
  QString msg;
  msg.append("Trimalyzer FATAL ERROR!\n");
  msg.append("Something bad has happened.  This bad thing is:\n-------\n");
  msg.append(errmsg);
  msg.append("\n-------\n...The program must be terminated immediately.  Sorry.");
  QMessageBox::critical(0,"Fatal Error",msg,QMessageBox::Abort);
  exit(1);
}

void warning(QString errmsg) {
  QString msg;
  msg.append("Trimalyzer Error!\n");
  msg.append(errmsg);
  msg.append("\nThis error is not fatal.");
  QMessageBox::warning(0,"Trimalyzer Warning",msg,QMessageBox::Ok);
}

