#ifndef PARAMETER_SELECT_H
#define PARAMETER_SELECT_H

#include <QDialog>
#include "definition.h"
#include <QListWidgetItem>
#include <QRegExp>

#define PARAMETER_NONE "--NONE--"

namespace Ui {
class parameter_select;
}

class parameter_select : public QDialog {
  Q_OBJECT

public:
  explicit parameter_select(definition *def_in, QString parameter, QWidget *parent = 0);
  ~parameter_select();
  QString get_selected_value();

private slots:
  void on_cancel_btn_clicked();
  void on_select_btn_clicked();
  void on_search_list_itemDoubleClicked(QListWidgetItem *item);
  void on_search_term_textChanged(const QString &arg1);

private:
  Ui::parameter_select *ui;
  QString selected_value;
  void update_selection();
  QRegExp filter;
  void refresh();
  definition *def;
};

#endif // PARAMETER_SELECT_H
