#include "parameter_select.h"
#include "ui_parameter_select.h"

parameter_select::parameter_select(definition *def_in, QString parameter, QWidget *parent) :
  QDialog(parent), ui(new Ui::parameter_select) {
  ui->setupUi(this);

  def = def_in;

  ui->search_label->setText("Select parameter matching " + parameter);

  filter.setPatternSyntax(QRegExp::Wildcard);
  filter.setPattern("*");
  filter.setCaseSensitivity(Qt::CaseInsensitive);

  refresh();
}

void parameter_select::refresh() {
  ui->search_list->clear();
  QStringList filtered_list;
  filtered_list.append(PARAMETER_NONE);
  for(int x=0;x<def->header.size();x++) {
    QString current_item = def->header.at(x);
    if(current_item.contains(filter) == true &&
       current_item.isEmpty() == false) {
      filtered_list.append(current_item);
    }
  }
  ui->search_list->insertItems(0,filtered_list);
}

parameter_select::~parameter_select() {
  delete ui;
}

QString parameter_select::get_selected_value() {
  return selected_value;
}

void parameter_select::on_cancel_btn_clicked() {
  reject();
}

void parameter_select::on_select_btn_clicked() {
  update_selection();
  accept();
}

void parameter_select::on_search_list_itemDoubleClicked(QListWidgetItem *item) {
  selected_value = item->text();
  accept();
}

void parameter_select::on_search_term_textChanged(const QString &arg1) {
  if(arg1.isEmpty() == true) {
    filter.setPattern("*");
  } else {
    filter.setPattern(arg1);
  }
  refresh();
}

void parameter_select::update_selection() {
  QList<QListWidgetItem *> l = ui->search_list->selectedItems();
  if(l.size() != 1) {
    QString empty;
    selected_value = empty;
  } else {
    selected_value = l.at(0)->text();
  }
}
