#ifndef GENERAL_H
#define GENERAL_H

#include <QStringList>

// quickly split a CSV string into a qstringlist, with optional escape/quote support
QStringList split_csv_line(QString in, bool process_quotes, bool process_backslashes);

// boundary enforcement on various numerical types
double clamp(double value, double min, double max);

double highest_of(double a, double b);

void fatal_error(QString errmsg);
void warning(QString errmsg);
void info_message(QString errmsg);

#endif // GENERAL_H
