#include <QSettings>
#include "config.h"
#include "settings_ui.h"
#include "ui_settings_ui.h"
#include "settings_item.h"
#include "general.h"

settings_ui::settings_ui(QWidget *parent) :
  QWidget(parent),
  ui(new Ui::settings_ui) {
  ui->setupUi(this);
  QSettings s(CONFIG_SETTINGS_DOMAIN,CONFIG_SETTINGS_GROUP);
  ui->darkness->setChecked(s.value("DARKNESS",false).toBool());
  // setting name, default value, minimum value, maximum value, setting description
  add_new_parameter("TUNE_KNOCK_COUNT_DIVISOR",98,1,10000,
                    "Divide knock count events by this number to determine circle plot size");
  add_new_parameter("TUNE_MIN_KNOCK_CIRCLE_RADIUS",4,2,100,
                    "Minimum radius for a knock explosion drawing");
  add_new_parameter("TUNE_MAX_KNOCK_CIRCLE_RADIUS",14,2,100,
                    "Maximum radius for a knock explosion drawing");
  add_new_parameter("TUNE_MINIMUM_RECORDS",5.2100,1,10000,
                    "The minimum number of data records influencing a particular fueling cell before it is considered 'valid'... "
                    "In interpolated mode, this is a dynamic value involving total data strength in a cell.");
  add_new_parameter("TUNE_VISUAL_RICH_TRIM",97.0000,0,200,
                    "A trim value percentage below which designates something that should warrant adjustment in a fueling table.  "
                    "This only affects how the cells are colored.");
  add_new_parameter("TUNE_VISUAL_LEAN_TRIM",103.0000,0,200,
                    "A trim value percentage above which designates something that should warrant adjustment in a fueling table.  "
                    "This only affects how the cells are colored.");
  add_new_parameter("TUNE_INTEGRATOR_REDUCTION",0.25,0,0.999,
                    "Lower values cause less integrator influence.");
  add_new_parameter("TUNE_INTEGRATOR_MAX",160,0,500,
                    "Integrator data is limited to this maximum percentage.");
  add_new_parameter("TUNE_INTEGRATOR_MIN",60.00,0,500,
                    "Integrator data is limited to this minimum percentage.");
  add_new_parameter("TUNE_DISTANCE_RPM",6875.0000,10,50000,
                    "This is the scalar for geometric RPM axis distance to try to square the table so diagonals make sense.  "
                    "Higher values tend to make the cells appear effectively closer together. "
                    "Lower values may be useful if RPM data is blending together too readily compared to MAP. ");
  add_new_parameter("TUNE_DISTANCE_MAP",118.30,5,50000,
                    "This is the scalar for geometric MAP axis distance to try to square the table so diagonals make sense.  "
                    "Higher values tend to make the cells appear effectively closer together. "
                    "Lower values may be useful if MAP data is blending together too readily compared to MAP. ");
  add_new_parameter("TUNE_INTERPOLATOR_GAIN",0.4210,0,1,
                    "This gain is added directly to any distance-based strength reduction between data points.  "
                    "The main purpose of allowing gain is to functionally clip the top range, so a range near the data point "
                    "will be fixed at 1.00 strength.  When increasing the gain, consider decreasing (steepening) the slope.");
  add_new_parameter("TUNE_INTERPOLATOR_SLOPE",0.0725,0.0001,1.00,
                    "This is the slope divisor of the relationship between distance and data strength.  "
                    "Lower values cause a much steeper slope, resulting in less data effectiveness at shorter distances, hence "
                    "increasing the relative localization of data.  Higher values spread data further and at higher intensity.");
  add_new_parameter("TUNE_INTERPOLATOR_NOISEFLOOR",0.1685,0,1.00,
                    "This is the noise floor.  Any calculated strength ratio below this value will be dropped.  "
                    "Increasing this value will ensure data doesn't spread too far.");
  add_new_parameter("TUNE_CELL_HYSTERSIS_RPM",80,0.1,10000,
                    "In loose cell interpolation, this is the hystersis value between RPM cells.");
  add_new_parameter("TUNE_CELL_HYSTERSIS_MAP",3,0.1,10000,
                    "In loose cell interpolation, this is the hystersis value between MAP cells.");
  add_new_parameter("TUNE_CELL_HYSTERSIS_MAF",3,0.1,10000,
                    "In loose cell interpolation, this is the hystersis value between MAF cells.");
}

void settings_ui::add_new_parameter(QString parameter, double default_value, double min, double max, QString help) {
  // error checking
  if(default_value > max) fatal_error("Setting " + parameter + " has a default value above the limit specified.");
  if(default_value < min) fatal_error("Setting " + parameter + " has a default value below the limit specified.");
  if(min >= max) fatal_error("Setting " + parameter + " has inappropriate minimum/maximum values.");
  //---------------
  settings_item *i = new settings_item(parameter,default_value,min,max,help);
  ui->settings_list_container->insertWidget(0,i);
  connect(this,SIGNAL(reset_to_default()),i,SLOT(reset_to_default()));
}

void settings_ui::add_new_parameter(QString parameter, double default_value, QString help) {
  add_new_parameter(parameter,default_value,-9999.00,9999.00,help);
}

settings_ui::~settings_ui() {
  delete ui;
}

void settings_ui::on_reset_all_btn_clicked() {
  emit reset_to_default();
}

void settings_ui::on_darkness_toggled(bool checked) {
  QSettings s(CONFIG_SETTINGS_DOMAIN,CONFIG_SETTINGS_GROUP);
  s.setValue("DARKNESS",checked);
}

void settings_ui::on_exit_btn_clicked() {
  emit return_to_main();
}
