#ifndef DATA_FILTER_H
#define DATA_FILTER_H

#include <QWidget>
#include "definition.h"

namespace Ui {
class data_filter;
}

class data_filter : public QWidget {
  Q_OBJECT

public:
  enum {
    OPERATION_UNDEFINED = -1,
    LESSTHAN,
    LESSTHAN_OR_EQ,
    GREATERTHAN,
    GREATERTHAN_OR_EQ,
    EQUALTO,
    NOTEQUALTO,
    IS_TRUE,
    IS_FALSE
  };

  explicit data_filter(int field, int operation_in, double value, definition *def_in, QWidget *parent = 0);
  explicit data_filter(definition *def_in, QWidget *parent = 0);
  explicit data_filter(QString config_in, definition *def_in, QWidget *parent = 0);
  ~data_filter();

  bool filter_match(QStringList *data);
  QString to_string();
  bool from_string(QString str);
  double get_value();
  bool is_valid();

  QString filter_description();

  //counters
  quint64 n_filtered;
  void reset_counters();

private slots:
  bool on_operation_btn_clicked();
  bool on_field_btn_clicked();
  void on_delete_btn_clicked();

private:
  definition *def;
  Ui::data_filter *ui;
  QString get_opstr(int op);
  int operation;
  int opfield;
  void set_op(int op);
  void set_field(int f);
  void set_value(double value);
  bool op_allows_value(int op);
  bool field_defined;
  bool filter_match_sub(QStringList *data);
signals:
  void delete_me(data_filter*);
};

#endif // DATA_FILTER_H
