#ifndef SETTINGS_UI_H
#define SETTINGS_UI_H

#include <QWidget>

namespace Ui {
class settings_ui;
}

class settings_ui : public QWidget {
  Q_OBJECT

public:
  explicit settings_ui(QWidget *parent = 0);
  ~settings_ui();

private slots:
  void on_reset_all_btn_clicked();
  void on_darkness_toggled(bool checked);
  void on_exit_btn_clicked();

signals:
  void return_to_main();

private:
  Ui::settings_ui *ui;
  void add_new_parameter(QString parameter, double default_value, double min, double max, QString help);
  void add_new_parameter(QString parameter, double default_value, QString help);
signals:
  void reset_to_default();
};

#endif // SETTINGS_UI_H
