#ifndef TABLE_CONFIG_H
#define TABLE_CONFIG_H

#include <QDialog>
#include <QTableWidget>
#include <QList>

#include "analyzer.h"

namespace Ui {
class table_config;
}

class table_config : public QDialog {
  Q_OBJECT

public:
  explicit table_config(table_geometry *layout_in, QWidget *parent = 0);
  ~table_config();
  QList<int> rpm_list;
  QList<int> map_list;
  bool flipped;

private slots:
  void on_ok_btn_clicked();
  void on_map_list_cellChanged(int row, int column);
  void on_rpm_list_cellChanged(int row, int column);
  void on_cancel_btn_clicked();
  void on_flipped_box_toggled(bool checked);
  void on_preset_name_textChanged(const QString &arg1);

private:
  table_geometry *layout;
  Ui::table_config *ui;
  QStringList get_contents(QTableWidget *w);
  void user_entry_ok(bool status);
  bool fill_list(QList<int> *list, QTableWidget *w);
  bool get_tables();
  void refresh();
  bool verify_list(QList<int> *list);
  void set_error(QString err);
  void populate(QVector<int> *list, QTableWidget *w);
  bool rpm_table_ok;
  bool map_table_ok;
  bool name_ok;
};

#endif // TABLE_CONFIG_H
