#ifndef DATALOG_H
#define DATALOG_H

#include <QString>
#include <QVector>
#include <QHash>

#include <QFile>
#include <QTextStream>

class datalog {
public:
  datalog(QString filename, datalog *master_log_in);
  ~datalog();
  bool is_valid();
  QString last_error;
  QString file_path;
  QStringList header;
  QHash<QString,int> header_search;
  quint64 rejected_lines;
  QStringList get_next_line();
  void seek_to_data();
private:
  bool valid;
  bool process_header();
  void critical_error(QString error_text);
  datalog *master_log;
  QFile f;
  QTextStream stream;
};

#endif // DATALOG_H
