#include "axis_geometry.h"

QStringList axis_geometry::get_headers() {
  QStringList header_out;
  for(int x=0;x<list.size();x++) {
    header_out.append(QString::number(list.at(x)));
  }
  return header_out;
}

QString axis_geometry::to_csv() {
  QString out;
  for(int x=0;x<list.size();x++) {
    out.append(QString::number(list.at(x)));
    if(x < list.size() - 1) out.append(",");
  }
  return out;
}

int axis_geometry::n_cells() {
  return list.size();
}

int axis_geometry::low_border(int cell) {
  if(cell == 0) {
    // a special case for secondary RPM tables
    if(list.count() > 1 && list.at(0) > 1250) {
       return high_border(0) - interval(1);
    } else {
      return 0;
    }
  }
  return list.at(cell - 1);
}

int axis_geometry::high_border(int cell) {
  return list.at(cell);
}

int axis_geometry::center(int cell) {
  return low_border(cell) + (interval(cell) / 2);
}

int axis_geometry::interval(int cell) {
  return high_border(cell) - low_border(cell);
}

bool axis_geometry::verify() {
  int last = -1;
  for(int x=0;x<list.size();x++) {
    if(list.at(x) > last) {
      last = list.at(x);
    } else {
      return false;
    }
  }
  return true;
}

int axis_geometry::max_range() {
  return list.at(list.size() - 1);
}
