#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QMainWindow>
#include "data_filter.h"
#include "field_mapping.h"
#include "datalog.h"
#include <QSettings>
#include "definition.h"
#include "analyzer.h"
#include "settings_ui.h"

namespace Ui {
class MainWindow;
}

class MainWindow : public QMainWindow {
  Q_OBJECT

public:
  explicit MainWindow(QWidget *parent = 0);
  ~MainWindow();

private slots:
  void on_add_log_btn_clicked();
  void on_remove_log_btn_clicked();
  void on_add_filter_btn_clicked();
  void data_filter_delete(data_filter *f);
  void on_clear_all_filters_btn_clicked();
  void on_auto_filters_btn_clicked();
  void on_advanced_settings_btn_clicked();
  void on_about_btn_clicked();
  void on_filters_save_btn_clicked();
  void on_filters_reload_btn_clicked();
  void on_analyzer_btn_clicked();
  void return_to_main_page();
  void on_trim_type_selector_currentIndexChanged(int index);
  void on_lean_bank_sw_toggled(bool checked);
  void on_ignore_int_sw_toggled(bool checked);

  void on_stackedWidget_currentChanged(int arg1);

private:
  Ui::MainWindow *ui;
  void set_ui_style(bool dark);

  datalog *master_log;
  QSettings *settings;
  definition *def;
  analyzer *analysis;
  settings_ui *settings_editor;

  void add_mapping(int mapping);
  void add_filter(int field, int operation, float value);
  void add_filter();
  void add_filter(data_filter *f);
  void guess_filters();
  void recall_filters();
  void remember_filters();
  int n_custom_filters();
  void populate_filters();
  void remove_all_filters();

  bool delete_log(QString filename);
  bool add_log(QString filename);
  void remove_mapping(int mapping);

  void populate_mappings();
  void remove_all_mappings();
  void refresh_mappings();

  void initialize_layout();
  void reset_layout();

  void enable_input(bool x);
  void enable_controls(bool value);

  QString get_default_path();
  void set_default_path(QString filename);
  bool logs_loaded();

  void dragEnterEvent(QDragEnterEvent *e);
  void dropEvent(QDropEvent *e);

  void mapping_set_visible(int mapping, bool visible);
  void rename_mapping(int mapping, QString new_name = QString());
};

#endif // MAINWINDOW_H
