#include "config.h"
#include "settings_item.h"
#include "ui_settings_item.h"
#include "general.h"

settings_item::settings_item(QString setting_name_in, double default_value_in,
                             double min, double max, QString helpstring_in, QWidget *parent) :
  QWidget(parent),
  ui(new Ui::settings_item) {
  ui->setupUi(this);
  settings_lock = true; // prevent redundant changes to settings
  default_value = default_value_in;
  setting_name = setting_name_in;
  helpstring = helpstring_in;
  settings = new QSettings(CONFIG_SETTINGS_DOMAIN,CONFIG_SETTINGS_GROUP);
  ui->parameter_label->setText(setting_name);
  ui->parameter_value->setMaximum(max);
  ui->parameter_value->setMinimum(min);
  double current_value = settings->value(setting_name,default_value).toDouble();
  if(current_value > max || current_value < min) {
    warning("Advanced setting " + setting_name + " was out of range, and has been reset to default.");
    current_value = default_value;
    settings->setValue(setting_name,default_value);
  }
  ui->parameter_value->setValue(current_value);
  ui->help_label->setText(helpstring);
  settings->setValue(setting_name,current_value); // update value
  settings_lock = false;
}

settings_item::~settings_item() {
  delete settings;
  delete ui;
}

void settings_item::on_default_btn_clicked() {
  reset_to_default();
}

void settings_item::on_parameter_value_valueChanged(double arg1) {
  if(settings_lock == true) return;
  settings->setValue(setting_name,arg1);
}

void settings_item::reset_to_default() {
  if(settings_lock == true) return;
  ui->parameter_value->setValue(default_value);
  on_parameter_value_valueChanged(default_value);
}
