#ifndef SETTINGS_ITEM_H
#define SETTINGS_ITEM_H

#include <QWidget>
#include <QSettings>

namespace Ui {
class settings_item;
}

class settings_item : public QWidget {
  Q_OBJECT

public:
  explicit settings_item(QString setting_name_in, double default_value_in,
                         double min, double max, QString helpstring_in, QWidget *parent = 0);
  ~settings_item();

private slots:
  void on_default_btn_clicked();
  void on_parameter_value_valueChanged(double arg1);

public slots:
  void reset_to_default();

private:
  Ui::settings_item *ui;
  bool settings_lock;
  QSettings *settings;
  double default_value;
  QString setting_name;
  QString helpstring;
};

#endif // SETTINGS_ITEM_H
