#ifndef FIELD_MAPPING_H
#define FIELD_MAPPING_H

#include <QWidget>
#include "definition.h"

namespace Ui {
class field_mapping;
}

class field_mapping : public QWidget {
  Q_OBJECT

public:
  explicit field_mapping(int parameter_index_in, definition *def_in, QWidget *parent = 0);
  ~field_mapping();
  void guess();
  bool is_mapped();
  int mapped_column;
  void set_temporary_name(QString name);
  void reset_name();

private slots:
  void on_toolButton_clicked();
  void on_auto_btn_clicked();

private:
  Ui::field_mapping *ui;
  int parameter_index;
  definition *def;
  void get_user_mapping();
  void refresh_ui();
  void remember_selection();
  QString parameter_name();
  void forget_selection();
};

#endif // FIELD_MAPPING_H
