#include "data_filter.h"
#include "ui_data_filter.h"
#include "opselector.h"
#include "parameter_select.h"
#include "general.h"

data_filter::data_filter(int field, int operation_in, double value, definition *def_in, QWidget *parent) :
  QWidget(parent),
  ui(new Ui::data_filter) {
  ui->setupUi(this);
  def = def_in;
  set_op(operation_in);
  set_field(field);
  set_value(value);
  reset_counters();
}

data_filter::data_filter(definition *def_in, QWidget *parent) :
  QWidget(parent),
  ui(new Ui::data_filter) {
  ui->setupUi(this);
  def = def_in;
  set_op(GREATERTHAN);
  set_field(1);
  set_value(0.00);
  on_field_btn_clicked();
  on_operation_btn_clicked();
  reset_counters();
}

data_filter::data_filter(QString config_in, definition *def_in, QWidget *parent) :
  QWidget(parent),
  ui(new Ui::data_filter) {
  ui->setupUi(this);
  def = def_in;
  from_string(config_in);
  reset_counters();
}

QString data_filter::filter_description() {
  QString out;
  out.append(def->name_of(opfield) + " " + get_opstr(operation));
  if(op_allows_value(operation) == true) out.append(" " + QString::number(get_value()));
  return out;
}

QString data_filter::to_string() {
  QString out;
  QString name = def->name_of(opfield);
  // FIXME should filter bunk from 'name' here
  out.append(name + ","); // field name
  out.append(QString::number(operation) + ",");
  out.append(QString::number(get_value()));
  return out;
}

bool data_filter::from_string(QString str) {
  // FIXME weak error checking
  QStringList config_in = str.split(',');
  QString name_in = config_in.at(0);
  QString operation_in = config_in.at(1);
  QString value_in = config_in.at(2);
  int field_index = def->index_of_item(name_in);
  set_field(field_index);
  set_value(value_in.toDouble());
  set_op(operation_in.toInt());
  return true;
}

void data_filter::set_value(double value) {
  ui->value_field->setValue(value);
}

double data_filter::get_value() {
  return ui->value_field->value();
}

bool data_filter::is_valid() {
  if(field_defined == false) return false;
  return true;
}

void data_filter::reset_counters() {
  n_filtered = 0;
}

void data_filter::set_field(int f) {
  opfield = f;
  if(f == -1) {
    field_defined = false;
    ui->field_btn->setText("UNKNOWN");
  } else {
    field_defined = true;
    ui->field_btn->setText(def->name_of(f));
  }
}

void data_filter::set_op(int op) {
  operation = op;
  ui->operation_btn->setText(get_opstr(op));
  ui->value_field->setHidden(! op_allows_value(op));
}

bool data_filter::op_allows_value(int op) {
  if(op == IS_TRUE) return false;
  if(op == IS_FALSE) return false;
  if(op == OPERATION_UNDEFINED) return false;
  return true;
}

data_filter::~data_filter() {
  delete ui;
}

bool data_filter::filter_match(QStringList *data) {
  // wrap filter_match so we get counters
  if(filter_match_sub(data) == false) {
    n_filtered++;
    return false;
  } else {
    return true;
  }
}

inline bool data_filter::filter_match_sub(QStringList *data) {
  if(is_valid() == false) return false;
  QString f = data->at(opfield);
  if(operation == IS_TRUE) {
    if(def->string_to_bool(f) == true) return true;
    return false;
  } else if(operation == IS_FALSE) {
    if(def->string_to_bool(f) == false) return true;
    return false;
  } else {
    bool conv_success = false;
    double x = f.toDouble(&conv_success);
    double y = ui->value_field->value();
    if(conv_success == false) return false;
    switch(operation) {
    case LESSTHAN:
      if(x < y) return true;
      return false;
      break;
    case LESSTHAN_OR_EQ:
      if(x <= y) return true;
      return false;
      break;
    case GREATERTHAN:
      if(x > y) return true;
      return false;
      break;
    case GREATERTHAN_OR_EQ:
      if(x >= y) return true;
      return false;
      break;
    case EQUALTO:
      if(x == y) return true;
      return false;
      break;
    case NOTEQUALTO:
      if(x != y) return true;
      return false;
      break;
    default:
      fatal_error("Undefined filter type in filter_match_sub()");
    }
  }
  return false;
}

bool data_filter::on_operation_btn_clicked() {
  opselector o(this);
  if(o.exec() == QDialog::Accepted) {
    set_op(o.get_value());
    return true;
  } else {
    return false;
  }
}

QString data_filter::get_opstr(int op) {
  switch(op) {
  case LESSTHAN:
    return QString("<");
    break;
  case LESSTHAN_OR_EQ:
    return QString("<=");
    break;
  case GREATERTHAN:
    return QString(">");
    break;
  case GREATERTHAN_OR_EQ:
    return QString(">=");
    break;
  case EQUALTO:
    return QString("=");
    break;
  case NOTEQUALTO:
    return QString("!=");
    break;
  case IS_TRUE:
    return QString("TRUE");
    break;
  case IS_FALSE:
    return QString("FALSE");
    break;
  default:
    fatal_error("Undefined filter type in get_opstr()");
  }
  return QString("UNDEFD"); // never reached
}

bool data_filter::on_field_btn_clicked() {
  parameter_select d(def, "Filter", this);
  if(d.exec() == QDialog::Accepted) {
    QString selected_parameter = d.get_selected_value();
    set_field(def->index_of_item(selected_parameter));
    return true;
  } else {
    return false;
  }
}

void data_filter::on_delete_btn_clicked() {
  emit delete_me(this);
}
