#ifndef DEFINITION_H
#define DEFINITION_H

#include <QHash>
#include <QStringList>
#include <QString>
#include <QSettings>

class definition {
public:
  definition();
  void apply_new_header(QStringList header_in);
  enum {
    STDMAP_LBLM = 1,
    STDMAP_RBLM,
    STDMAP_LINT,
    STDMAP_RINT,
    STDMAP_BLMCELL,
    STDMAP_RPM,
    STDMAP_MAP,
    STDMAP_MAF,
    STDMAP_COOLANT,
    STDMAP_TIMESTAMP,
    STDMAP_CLOSEDLOOP,
    STDMAP_WOT,
    STDMAP_KNOCKCOUNT,
    STDMAP_TPS,
    STDMAP_N_VALUES
  };
  enum {
    TRIM_FORMAT_RAW,
    TRIM_FORMAT_PERCENT_SIGNED,
    TRIM_FORMAT_PERCENT_WHOLE,
    TRIM_FORMAT_ARBITRARY
  };
  static QString name_of_parameter(int parameter);
  int guess_best_field(int value);
  int guess_best_field(QString value);
  int index_of(int value);
  bool exists(int value);
  bool string_to_bool(QString str);
  QStringList header;
  QString name_of(int value);
  int index_of_item(QString value);
  void reset();
  int trim_type;
private:
  QHash<QString,bool> boolean_lookup_table;
  QHash<QString,QStringList> header_lookup_table;
  QHash<int,int> field_mapping_list;
  void get_boolean_data(QString lookup, bool is_true);
  QSettings *conf;
  void verify_dictionary();
};

#endif // DEFINITION_H
