#include <QSettings>
#include "config.h"
#include "field_mapping.h"
#include "ui_field_mapping.h"
#include "parameter_select.h"

field_mapping::field_mapping(int parameter_index_in, definition *def_in, QWidget *parent) :
  QWidget(parent),
  ui(new Ui::field_mapping) {
  ui->setupUi(this);

  def = def_in;

  // get parameter
  parameter_index = parameter_index_in;
  ui->parameter->setText(parameter_name());
  guess();
}

QString field_mapping::parameter_name() {
  return def->name_of_parameter(parameter_index);
}

void field_mapping::remember_selection() {
  if(mapped_column <= -1) {
    forget_selection();
    return;
  }
  QString selection = def->name_of(mapped_column);
  QSettings conf(CONFIG_SETTINGS_DOMAIN,CONFIG_SETTINGS_GROUP);
  conf.setValue("USER_DICT_" + parameter_name(),selection.toUpper());
}

void field_mapping::forget_selection() {
  QSettings conf(CONFIG_SETTINGS_DOMAIN,CONFIG_SETTINGS_GROUP);
  conf.remove("USER_DICT_" + parameter_name());
}

void field_mapping::guess() {
  // get dictionary guess and set map
  mapped_column = def->index_of(parameter_index);
  // if we remember autoselection here as user selection, could speed up guessing next time
  // and nobody will know ...
  remember_selection();
  refresh_ui();
}

bool field_mapping::is_mapped() {
  if(mapped_column == -1) return false;
  return true;
}

void field_mapping::set_temporary_name(QString name) {
  ui->parameter->setText(name);
}

void field_mapping::reset_name() {
  ui->parameter->setText(parameter_name());
}

void field_mapping::refresh_ui() {
  if(mapped_column > -1) {
    QString selection_name = def->name_of(mapped_column);
    ui->map->setText(selection_name);
    ui->map->setEnabled(true);
  } else {
    ui->map->setText("UNKNOWN");
    ui->map->setEnabled(false);
  }
  if(def->header.size() < 1) {
    ui->toolButton->setEnabled(false);
  } else {
    ui->toolButton->setEnabled(true);
  }
}

field_mapping::~field_mapping() {
  delete ui;
}

void field_mapping::on_toolButton_clicked() {
   get_user_mapping();
}

void field_mapping::get_user_mapping() {
  parameter_select d(def, def->name_of_parameter(parameter_index), this);
  if(d.exec() == QDialog::Accepted) {
    QString selected_parameter = d.get_selected_value();
    mapped_column = def->index_of_item(selected_parameter);
    remember_selection();
    refresh_ui();
  } else {
    return;
  }
}

void field_mapping::on_auto_btn_clicked() {
   guess();
}
