#include "opselector.h"
#include "ui_opselector.h"
#include "data_filter.h"

opselector::opselector(QWidget *parent) :
  QDialog(parent),
  ui(new Ui::opselector) {
  ui->setupUi(this);
  selected_value = -1;
}

opselector::~opselector() {
  delete ui;
}

int opselector::get_value() {
  return selected_value;
}

void opselector::choose_p(int choice) {
  selected_value = choice;
  accept();
}

void opselector::on_eq_btn_clicked() {
  choose_p(data_filter::EQUALTO);
}

void opselector::on_nteq_btn_clicked() {
  choose_p(data_filter::NOTEQUALTO);
}

void opselector::on_lessthan_btn_clicked() {
  choose_p(data_filter::LESSTHAN);
}

void opselector::on_lessthaneq_btn_clicked() {
  choose_p(data_filter::LESSTHAN_OR_EQ);
}

void opselector::on_grtr_btn_clicked() {
  choose_p(data_filter::GREATERTHAN);
}

void opselector::on_grtr_eq_btn_clicked() {
  choose_p(data_filter::GREATERTHAN_OR_EQ);
}

void opselector::on_cancel_btn_clicked() {
  reject();
}

void opselector::on_true_btn_clicked() {
  choose_p(data_filter::IS_TRUE);
}

void opselector::on_false_btn_clicked() {
  choose_p(data_filter::IS_FALSE);
}
