#include "config.h"
#include "datalog.h"
#include "general.h"

datalog::datalog(QString filename, datalog *master_log_in) {
  valid = false;
  rejected_lines = 0;
  file_path = filename;
  master_log = master_log_in;
  f.setFileName(filename);
  if(f.open(QIODevice::ReadOnly) == false) {
    critical_error("Error loading file: " + file_path + " " + f.errorString());
  } else {
    stream.setDevice(&f); // configure stream
    stream.seek(0);
    process_header();
  }
}

datalog::~datalog() {
  f.close();
}

bool datalog::is_valid() {
  return valid;
}

void datalog::critical_error(QString error_text) {
  last_error = error_text;
  valid = false;
}

bool datalog::process_header() {
  stream.seek(0); // to beginning
  header = split_csv_line(stream.readLine(),true,false);
  if(header.size() < 3) { // .. if not very many fields
    header = split_csv_line(stream.readLine(),true,false); // try next line
  }
  // verify header
  // FIXME this is very strict
  if(master_log != NULL) {
    if(header.size() != master_log->header.size()) {
      critical_error("Log file header doesn't match existing log files");
      return false;
    }
    for(int x=0;x<header.size();x++) {
      if(header.at(x) != master_log->header.at(x)) {
        critical_error("Log file header doesn't match existing log files");
        return false;
      }
    }
  }
  // build hash table
  for(int x=0;x<header.size();x++) {
    header_search[header.at(x)] = x;
  }
  valid = true;
  return true;
}

void datalog::seek_to_data() {
  stream.seek(0);
  // skip first couple of lines
  for(int x=0;x<2;x++) {
    if(stream.atEnd()) return;
    stream.readLine();
  }
}

QStringList datalog::get_next_line() {
  QStringList line_in;
  while(stream.atEnd() == false) {
    line_in = split_csv_line(stream.readLine(),true,false);
#ifdef ALDLDROID_WORKAROUND
    while(line_in.size() < header.size()) line_in.append("0.00");
#endif
    if(line_in.size() == header.size()) {
      return line_in; // loop until right line size found
    } else {
      rejected_lines++;
    }
  }
  QStringList empty;
  return empty; // designated end of file !
}

