#include "table_config.h"
#include "ui_table_config.h"

// for now, we re-purpose rpm_list as maf afgs ...

table_config::table_config(table_geometry *layout_in, QWidget *parent) :
  QDialog(parent),
  ui(new Ui::table_config) {
  ui->setupUi(this);
  user_entry_ok(false);
  rpm_table_ok = false;
  map_table_ok = false;
  name_ok = false;
  layout = layout_in;
  if(layout->maf == true) {
    ui->flipped_box->setEnabled(false);
    ui->map_list->setEnabled(false);
    ui->row_label->setText("MAF");
    ui->col_label->setText("...");
    populate(&layout->row.list,ui->rpm_list);
  } else {
    flipped = layout->flipped;
    ui->flipped_box->setChecked(flipped);
    ui->preset_name->setText(layout->name);
    populate(&layout->col.list,ui->map_list);
    populate(&layout->row.list,ui->rpm_list);
  }
  get_tables();
  refresh();
}

table_config::~table_config() {
  delete ui;
}

void table_config::populate(QVector<int> *list, QTableWidget *w) {
  w->clear();
  for(int x=0;x<list->size();x++) {
    QTableWidgetItem *item = new QTableWidgetItem;
    item->setText(QString::number(list->at(x)));
    w->setItem(x,0,item);
  }
}

void table_config::on_ok_btn_clicked() {
  if(get_tables() == false) {
    user_entry_ok(false);
    return;
  }
  layout->name = ui->preset_name->text();
  layout->row.list.clear();
  for(int x=0;x<rpm_list.size();x++) {
    layout->row.list.append(rpm_list.at(x));
  }
  if(layout->maf == false) {
    layout->col.list.clear();
    for(int x=0;x<map_list.size();x++) {
      layout->col.list.append(map_list.at(x));
    }
  }
  layout->flipped = flipped;
  if(layout->verify() == false) return;
  accept();
}

void table_config::user_entry_ok(bool status) {
  ui->ok_btn->setEnabled(status);
}

void table_config::refresh() {
  if(layout->maf == true) {
    if(rpm_table_ok && name_ok) {
      user_entry_ok(true);
      set_error("OK");
    } else {
      user_entry_ok(false);
    }
  } else {
    if(rpm_table_ok && map_table_ok && name_ok) {
      user_entry_ok(true);
      set_error("OK");
    } else {
      user_entry_ok(false);
    }
  }
}

bool table_config::get_tables() {
  rpm_table_ok = fill_list(&rpm_list,ui->rpm_list);
  if(layout->maf == false) map_table_ok = fill_list(&map_list,ui->map_list);
  refresh();
  return true;
}

bool table_config::fill_list(QList<int> *list, QTableWidget *w) {
  list->clear();
  QStringList text_values = get_contents(w);
  for(int x=0;x<text_values.size();x++) {
    bool r;
    QString value_str = text_values.at(x);
    int value = value_str.toInt(&r);
    if(r == true) {
      list->append(value);
    } else {
      set_error("Non-numerical value entered");
      return false;
    }
  }
  return verify_list(list);
}

bool table_config::verify_list(QList<int> *list) {
  if(list->size() < 2) {
    set_error("Not enough values");
    return false;
  }
  int last_value = -1;
  for(int x=0;x<list->size();x++) {
    if(list->value(x) < last_value) {
      set_error("Out-of-order value entered");
      return false;
    } else {
      last_value = list->value(x);
    }
  }
  return true;
}

QStringList table_config::get_contents(QTableWidget *w) {
  QStringList out;
  int max_values = w->rowCount();
  for(int x=0;x<max_values;x++) {
    QTableWidgetItem *cell = w->item(x,0);
    if(cell == NULL || cell->text().isEmpty()) {
      return out;
    }
    out.append(cell->text());
  }
  return out;
}

void table_config::on_map_list_cellChanged(int, int) {
  map_table_ok = fill_list(&map_list,ui->map_list);
  refresh();
}

void table_config::on_rpm_list_cellChanged(int, int) {
  rpm_table_ok = fill_list(&rpm_list,ui->rpm_list);
  refresh();
}

void table_config::set_error(QString err) {
  ui->err_label->setText(err);
}

void table_config::on_cancel_btn_clicked() {
  reject();
}

void table_config::on_flipped_box_toggled(bool checked) {
  flipped = checked;
}

void table_config::on_preset_name_textChanged(const QString &arg1) {
  if(arg1.isEmpty() == true) {
    name_ok = false;
    set_error("Specify a preset name");
  } else {
    name_ok = true;
  }
  refresh();
}

